/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model.presenter;

import com.comalatech.confluence.workflowreports.model.WorkflowReportFilters;
import com.comalatech.confluence.workflowreports.model.presenter.MacroParametersPresenter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowActionsReportFiltersJsonPresenter
implements MacroParametersPresenter {
    private static final Logger log = LoggerFactory.getLogger(WorkflowActionsReportFiltersJsonPresenter.class);
    public static final String ACTIONS_FILTER_KEY = "reportActionsFilter";
    public static final String WORKFLOW_FILTER_KEY = "reportWorkflowFilter";
    private final WorkflowReportFilters filters;
    private final ObjectMapper objectMapper;

    public WorkflowActionsReportFiltersJsonPresenter(WorkflowReportFilters filters, ObjectMapper objectMapper) {
        this.filters = filters;
        this.objectMapper = objectMapper;
    }

    @Override
    public Map<String, Object> present() {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        propertiesMap.put(ACTIONS_FILTER_KEY, this.toJson(this.filters.getStateNames()));
        propertiesMap.put(WORKFLOW_FILTER_KEY, this.toJson(this.filters.getSpaceWorkflows()));
        return propertiesMap;
    }

    private String toJson(Object parameter) {
        if (parameter != null) {
            try {
                return this.objectMapper.writeValueAsString(parameter);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return "";
    }
}

