/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model;

import com.comalatech.confluence.workflowreports.macro.parameter.FieldListReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.ReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.StringListReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.model.StateReportParameters;
import com.comalatech.confluence.workflowreports.model.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CommonWorkflowReportOptions {
    private final List<String> spaceKeys;
    private final String parentPageId;
    private final String numberOfItemsPerPage;
    private final List<String> labels;
    private final List<String> states;
    private final List<String> workflows;
    private List<Field> cqlFilters = null;
    private String cql = null;
    protected Map<String, ReportParameterValue> paramValues = new HashMap<String, ReportParameterValue>();
    private final boolean allLabelsMandatory;

    public CommonWorkflowReportOptions(List<ReportParameter> parameters) {
        for (ReportParameter p : parameters) {
            this.paramValues.put(p.getKey(), p.getValue());
        }
        this.numberOfItemsPerPage = this.getStringValueFrom(this.paramValues.get(StateReportParameters.MAX_ITEMS_PER_PAGE.getKey()));
        this.parentPageId = this.getStringValueFrom(this.paramValues.get(StateReportParameters.PARENT_PAGE.getKey()));
        this.states = this.getListValueFrom(this.paramValues.get(StateReportParameters.STATE.getKey()));
        this.workflows = this.getListValueFrom(this.paramValues.get(StateReportParameters.WORKFLOW.getKey()));
        ReportParameterValue cqlFilterReportParamValue = this.paramValues.get(StateReportParameters.CQL_FILTER.getKey());
        if (cqlFilterReportParamValue != null) {
            if (cqlFilterReportParamValue.getClass().equals(FieldListReportParameterValue.class)) {
                this.cqlFilters = this.getListValueFrom(cqlFilterReportParamValue);
            } else {
                this.cql = this.getStringValueFrom(cqlFilterReportParamValue);
            }
        }
        this.spaceKeys = this.getListValueFrom(this.paramValues.get(StateReportParameters.SPACE.getKey()));
        boolean mandatoryLabels = false;
        this.labels = new ArrayList<String>();
        for (String label : this.getListValueFrom(this.paramValues.get(StateReportParameters.LABEL.getKey()))) {
            if (label.startsWith("&")) {
                mandatoryLabels = true;
            }
            this.labels.add(StringUtils.removeStart((String)label, (String)"&"));
        }
        this.allLabelsMandatory = mandatoryLabels;
    }

    protected String getStringValueFrom(ReportParameterValue value) {
        if (value instanceof StringReportParameterValue) {
            return (String)((StringReportParameterValue)value).getValue();
        }
        return null;
    }

    protected List getListValueFrom(ReportParameterValue value) {
        if (value instanceof StringListReportParameterValue) {
            return (List)((StringListReportParameterValue)value).getValue();
        }
        if (value instanceof FieldListReportParameterValue) {
            return (List)((FieldListReportParameterValue)value).getValue();
        }
        return Collections.emptyList();
    }

    public String getFirstSpaceKey() {
        return CollectionUtils.isEmpty(this.spaceKeys) ? null : this.spaceKeys.get(0);
    }

    public boolean isSingleSpace() {
        return this.spaceKeys.size() == 1 && StringUtils.isNotBlank((CharSequence)this.spaceKeys.get(0));
    }

    public List<String> getSpaceKeys() {
        return this.spaceKeys;
    }

    public String getParentPageId() {
        return this.parentPageId;
    }

    public String getNumberOfItemsPerPage() {
        return this.numberOfItemsPerPage;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public List<String> getStates() {
        return this.states;
    }

    public List<String> getWorkflows() {
        return this.workflows;
    }

    public List<Field> getCqlFilters() {
        return this.cqlFilters;
    }

    public String getCql() {
        return this.cql;
    }

    public Map<String, ReportParameterValue> getParamValues() {
        return this.paramValues;
    }

    public boolean isAllLabelsMandatory() {
        return this.allLabelsMandatory;
    }
}

