/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model;

import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.workflow.model.SignatureType;
import java.util.HashMap;
import java.util.Map;

public class ApprovalActivity
extends Activity {
    private Approver approver;
    private ApprovalCheck approvalCheck;

    public ApprovalActivity(ApprovalCheck approvalCheck, Approver approver) {
        super(approver.getUser(), approver.getDate());
        this.setComment(approver.getComment());
        this.approver = approver;
        this.approvalCheck = approvalCheck;
    }

    @Override
    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("approvalName", this.approvalCheck.getName());
        attributes.put("approved", Boolean.toString(this.approver.isApproved()));
        return attributes;
    }

    public Approver getApprover() {
        return this.approver;
    }

    public ApprovalCheck getApprovalCheck() {
        return this.approvalCheck;
    }

    @Override
    public String getActivityId() {
        return "";
    }

    @Override
    public String getActivityKey() {
        return "approval";
    }

    @Override
    public String getSignatureMode() {
        switch (this.approver.getESignature()) {
            case CONFLUENCE: {
                return this.getConfluenceSignatureMode(this.approver.getSignatureType());
            }
            case OTP: {
                return this.getOTPSignatureMode(this.approver.getSignatureType());
            }
        }
        return "";
    }

    private String getConfluenceSignatureMode(SignatureType signatureType) {
        ComalaI18nBean i18nBean = ComalaI18nBean.getComalaI18nBean();
        switch (signatureType) {
            case PASSWORD: {
                return i18nBean.getText("com.comalatech.activity.report.approval.esig.password");
            }
            case USERID_AND_PASSWORD: {
                return i18nBean.getText("com.comalatech.activity.report.approval.esig.user");
            }
        }
        return "";
    }

    private String getOTPSignatureMode(SignatureType signatureType) {
        ComalaI18nBean i18nBean = ComalaI18nBean.getComalaI18nBean();
        switch (signatureType) {
            case PASSWORD: {
                return i18nBean.getText("com.comalatech.activity.report.approval.esig.otp.password");
            }
            case USERID_AND_PASSWORD: {
                return i18nBean.getText("com.comalatech.activity.report.approval.esig.otp.user");
            }
        }
        return "";
    }
}

