/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.manager.tasks;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.comalatech.confluence.documentActions.services.model.search.ActionTypes;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.restv2.model.documentreport.DocumentReport;
import com.comalatech.confluence.workflow.restv2.model.documentreport.TaskReport;
import com.comalatech.confluence.workflow.restv2.model.documentreport.WorkflowsReportData;
import com.comalatech.confluence.workflowreports.manager.tasks.WorkflowTaskReportManager;
import com.comalatech.confluence.workflowreports.model.ExportWorkflowTaskReportEntry;
import com.comalatech.confluence.workflowreports.model.WorkflowTasksReportOptions;
import com.comalatech.confluence.workflowreports.service.TaskDocumentReportService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExportTaskReport
implements WorkflowTaskReportManager {
    private static final Logger log = LoggerFactory.getLogger(ExportTaskReport.class);
    private static final int LIMIT = 20;
    private static final String REPORT_CQL_FILTER = "awphasworkflow=true";
    private static final String CQL_QUERY_PARAM = "cqlQuery";
    private final PageManager pageManager;
    private final TaskDocumentReportService taskDocumentReportService;
    private final ComalaI18nBean comalaI18nBean;

    public ExportTaskReport(PageManager pageManager, TaskDocumentReportService taskDocumentReportService, ComalaI18nBean comalaI18nBean) {
        this.pageManager = pageManager;
        this.taskDocumentReportService = taskDocumentReportService;
        this.comalaI18nBean = comalaI18nBean;
    }

    @Override
    public List<ExportWorkflowTaskReportEntry> createReport(WorkflowTasksReportOptions options, Map<String, Object> parameters) {
        int start = 0;
        int limit = StringUtils.isNotBlank((CharSequence)options.getNumberOfItemsPerPage()) ? Integer.parseInt(options.getNumberOfItemsPerPage()) : 20;
        try {
            DocumentReport report = this.taskDocumentReportService.generateDocumentReport(this.buildCqlQuery(options, parameters), start, limit);
            return this.buildReport(report);
        }
        catch (WorkflowException e) {
            log.error(e.getMessage());
            return new ArrayList<ExportWorkflowTaskReportEntry>();
        }
    }

    private String buildCqlQuery(WorkflowTasksReportOptions options, Map<String, Object> parameters) throws WorkflowException {
        StringJoiner stateJoiner = new StringJoiner("\",\"", "state IN (\"", "\")");
        options.getStates().forEach(stateJoiner::add);
        StringJoiner workflowJoiner = new StringJoiner("\",\"", "workflowname IN (\"", "\")");
        options.getWorkflows().forEach(workflowJoiner::add);
        String cqlQuery = REPORT_CQL_FILTER;
        cqlQuery = StringUtils.isNotBlank((CharSequence)((String)parameters.get(CQL_QUERY_PARAM))) ? cqlQuery + " AND " + parameters.get(CQL_QUERY_PARAM) : cqlQuery;
        cqlQuery = !options.getStates().isEmpty() ? cqlQuery + " AND " + stateJoiner : cqlQuery;
        cqlQuery = !options.getWorkflows().isEmpty() ? cqlQuery + " AND " + workflowJoiner : cqlQuery;
        cqlQuery = !StringUtils.isBlank((CharSequence)options.getAssignee()) ? cqlQuery + " AND " + ActionTypes.TASK.getCqlField() + " IN (\"" + options.getAssignee() + "\")" : cqlQuery;
        return cqlQuery;
    }

    private List<ExportWorkflowTaskReportEntry> buildReport(DocumentReport results) throws WorkflowException {
        ArrayList<ExportWorkflowTaskReportEntry> report = new ArrayList<ExportWorkflowTaskReportEntry>();
        for (WorkflowsReportData result : results.getWorkflowsReportList()) {
            report.addAll(this.buildEntries(result));
        }
        report.sort(Comparator.comparing(ExportWorkflowTaskReportEntry::getPageTitle, String.CASE_INSENSITIVE_ORDER).reversed());
        return report;
    }

    private List<ExportWorkflowTaskReportEntry> buildEntries(WorkflowsReportData result) throws WorkflowException {
        AbstractPage page = this.pageManager.getAbstractPage(result.getContentData().getId());
        if (page == null) {
            throw new WorkflowException("There was an error while creating the report.");
        }
        ArrayList<ExportWorkflowTaskReportEntry> entries = new ArrayList<ExportWorkflowTaskReportEntry>();
        if (result.getHasTasks().equals("true")) {
            if (!result.getTaskReportData().getPendingTasks().isEmpty()) {
                entries.addAll(result.getTaskReportData().getPendingTasks().stream().map(pendingTask -> this.buildTask((TaskReport)pendingTask, "Active", page, result.getCurrentState())).collect(Collectors.toList()));
            }
            if (!result.getTaskReportData().getCompletedTasks().isEmpty()) {
                entries.addAll(result.getTaskReportData().getCompletedTasks().stream().map(completedTask -> this.buildTask((TaskReport)completedTask, "Completed", page, result.getCurrentState())).collect(Collectors.toList()));
            }
            return entries;
        }
        return Collections.EMPTY_LIST;
    }

    private ExportWorkflowTaskReportEntry buildTask(TaskReport task, String status, AbstractPage page, String currentState) {
        return ExportWorkflowTaskReportEntry.builder().pageTitle(page.getTitle()).pageLink(this.getBaseUrl() + page.getUrlPath()).state(currentState).taskName(task.getName()).status(status).assignedBy(task.getAssignedBy() != null ? task.getAssignedBy().getDisplayName() : "").assignmentDate(TimerUtils.parseDateWithConfluenceDateFormat(new Date(task.getAssignmentDate()))).assignedTo(task.getAssignedTo() != null ? task.getAssignedTo().getDisplayName() : "").dueDate(TimerUtils.parseDateWithConfluenceDateFormat(new Date(task.getDueDate()))).timeSpent(this.getDuration(task.getTimeSpent())).build();
    }

    private String getBaseUrl() {
        String domainName = GeneralUtil.getGlobalSettings().getBaseUrl();
        if (StringUtils.isNotBlank((CharSequence)domainName) && domainName.endsWith("/")) {
            domainName = domainName.substring(0, domainName.length() - 1);
        }
        return domainName;
    }

    private String getDuration(long timeInMilis) {
        long days = TimeUnit.MILLISECONDS.toDays(timeInMilis);
        long hours = TimeUnit.MILLISECONDS.toHours(timeInMilis);
        if (days < 1L) {
            if (hours < 1L) {
                return this.comalaI18nBean.getText("report.task.period.lessThanHour");
            }
            return this.comalaI18nBean.getText("report.task.period.hours", new Object[]{String.valueOf(hours)});
        }
        return this.comalaI18nBean.getText("report.task.period.days", new Object[]{String.valueOf(days)});
    }
}

