/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.macros.templates.NoBodyBaseMacro;
import com.comalatech.confluence.workflow.restv2.model.report.RestSpaceReportFilterWorkflow;
import com.comalatech.confluence.workflow.service.ApprovalsSearchService;
import com.comalatech.confluence.workflowreports.model.CommonWorkflowReportOptions;
import com.comalatech.confluence.workflowreports.model.WorkflowReportFilters;
import com.comalatech.workflow.model.Workflow;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class BaseWorkflowReportMacro
extends NoBodyBaseMacro
implements Macro {
    public static final String SEND_EMAIL_MACRO = "send-email";
    protected AdhocWorkflowsLicenseManager licenseManager;
    protected WorkflowsFeatureManager workflowsFeatureManager;
    protected ApprovalsSearchService approvalsSearchService;
    protected WorkflowService workflowService;
    @ComponentImport
    protected PageManager pageManager;
    @ComponentImport
    protected UserAccessor userAccessor;
    protected final ObjectMapper objectMapper = new ObjectMapper();

    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        try {
            return this.execute(parameters, (RenderContext)conversionContext.getPageContext());
        }
        catch (MacroException e) {
            throw new MacroExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public String getCurrentSpaceKey(RenderContext renderContext) throws MacroException {
        if (renderContext instanceof PageContext && this.getPageContext(renderContext) != null) {
            return this.getPageContext(renderContext).getSpaceKey();
        }
        return null;
    }

    WorkflowReportFilters buildReportFilters(CommonWorkflowReportOptions options) {
        List<String> states = this.getReportFilter(options);
        List<RestSpaceReportFilterWorkflow> workflows = this.getReportWorkflowFilter(options);
        return new WorkflowReportFilters(states, workflows);
    }

    protected List<String> getReportFilter(CommonWorkflowReportOptions options) {
        ArrayList<String> spaceStates = new ArrayList<String>();
        if (options.isSingleSpace()) {
            spaceStates.addAll(this.approvalsSearchService.getSpaceStates(options.getFirstSpaceKey()));
        }
        return spaceStates;
    }

    protected List<RestSpaceReportFilterWorkflow> getReportWorkflowFilter(CommonWorkflowReportOptions options) {
        ArrayList<RestSpaceReportFilterWorkflow> restWorkflows = new ArrayList<RestSpaceReportFilterWorkflow>();
        if (this.workflowsFeatureManager.isWorkflowsApp() || this.workflowsFeatureManager.isWorkflowsLiteApp()) {
            ArrayList<Workflow> workflows = new ArrayList<Workflow>();
            if (options.isSingleSpace()) {
                workflows.addAll(this.workflowService.getWorkflows(options.getFirstSpaceKey()));
            }
            for (Workflow workflow : workflows) {
                if (!workflow.isActive()) continue;
                RestSpaceReportFilterWorkflow restWorkflow = new RestSpaceReportFilterWorkflow();
                restWorkflow.name = workflow.getName();
                restWorkflow.states = workflow.getStateNames();
                restWorkflows.add(restWorkflow);
            }
        }
        return restWorkflows;
    }

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    @Override
    public boolean isInline() {
        return true;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    public void setLicenseManager(AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setWorkflowsFeatureManager(WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    public void setApprovalsSearchService(ApprovalsSearchService approvalsSearchService) {
        this.approvalsSearchService = approvalsSearchService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

