/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.user.User;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.service.ApprovalsSearchService;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalWorkflowsAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(GlobalWorkflowsAction.class);
    private String pagesWithWorkflow;
    private String spacesWithWithWorkflow;
    private AdhocWorkflowsLicenseManager licenseManager;
    private WorkflowContainerManager workflowContainerManager;
    @ComponentImport
    private WikiStyleRenderer wikiStyleRenderer;
    @ComponentImport
    private WebResourceManager webResourceManager;
    @ComponentImport
    private SpaceManager spaceManager;
    private ApprovalsSearchService approvalsSearchService;
    private WorkflowStatisticsManager workflowStatisticsManager;
    private final String docoUrl = "https://apps.appf.re/cdmdc/doc/globalworkflows/vqKsn3";

    public String execute() throws Exception {
        this.webResourceManager.requireResource("confluence.web.resources:jquery");
        this.webResourceManager.requireResource("confluence.web.resources:ajs");
        this.calculateUsageStats();
        return "success";
    }

    private void calculateUsageStats() {
        int pagesCount = this.approvalsSearchService.getNumberOfPagesWithWorkflow();
        if (pagesCount > 0) {
            this.pagesWithWorkflow = pagesCount >= 1000 ? pagesCount + "+" : String.valueOf(pagesCount);
            int spacesCount = this.approvalsSearchService.getNumberOfSpacesWithWorkflow();
            this.spacesWithWithWorkflow = spacesCount >= 20 ? spacesCount + "+" : String.valueOf(spacesCount);
        }
    }

    public String render(String body) {
        PageContext context = new PageContext();
        context.pushRenderMode(RenderMode.suppress((long)1L));
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, body);
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setWorkflowContainerManager(WorkflowContainerManager workflowContainerManager) {
        this.workflowContainerManager = workflowContainerManager;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    public List<Workflow> getGlobalWorkflows() {
        return this.workflowContainerManager.getWorkflowTemplates(null);
    }

    public Space getSpace(String spaceKey) {
        return this.spaceManager.getSpace(spaceKey);
    }

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public String getPagesWithWorkflow() {
        return this.pagesWithWorkflow;
    }

    public String getSpacesWithWithWorkflow() {
        return this.spacesWithWithWorkflow;
    }

    public void setLicenseManager(AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setWorkflowStatisticsManager(WorkflowStatisticsManager workflowStatisticsManager) {
        this.workflowStatisticsManager = workflowStatisticsManager;
    }

    public WorkflowStatisticsManager getWorkflowStatisticsManager() {
        return this.workflowStatisticsManager;
    }

    public String getDocoUrl() {
        return "https://apps.appf.re/cdmdc/doc/globalworkflows/vqKsn3";
    }

    public void setApprovalsSearchService(ApprovalsSearchService approvalsSearchService) {
        this.approvalsSearchService = approvalsSearchService;
    }

    public WebResourceManager getWebResourceManager() {
        return this.webResourceManager;
    }
}

