/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.supportconsole.mappers;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.documentActivity.upgrade.accessor.SpaceUpgradeAccessor;
import com.comalatech.confluence.documentActivity.upgrade.accessor.entity.UpgradeTaskRecord;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.PluginLicenseStatus;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.dao.sax.PageStateConverter;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.dao.sax.ApprovalChecksConverter;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.supportconsole.mappers.contract.SupportConsoleReportDataPopulator;
import com.comalatech.confluence.workflow.supportconsole.model.DebugData;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="debugDataPopulator")
public class DebugDataPopulator
implements SupportConsoleReportDataPopulator<DebugData, AbstractPage> {
    private final WorkflowAccessor workflowAccessor;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final PluginAccessor pluginAccessor;
    private final AdhocWorkflowsLicenseManager licenseManager;
    private final StateAccessor stateAccessor;
    private final ApprovalAccessor approvalAccessor;
    private final SpaceUpgradeAccessor spaceUpgradeAccessor;
    private final DocumentActivityUpgradeService documentActivityUpgradeService;
    private final String newLine;

    public DebugDataPopulator(WorkflowAccessor workflowAccessor, WorkflowsFeatureManager workflowsFeatureManager, @ComponentImport PluginAccessor pluginAccessor, AdhocWorkflowsLicenseManager adhocWorkflowsLicenseManager, StateAccessor stateAccessor, ApprovalAccessor approvalAccessor, SpaceUpgradeAccessor spaceUpgradeAccessor, DocumentActivityUpgradeService documentActivityUpgradeService) {
        this.workflowAccessor = workflowAccessor;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.pluginAccessor = pluginAccessor;
        this.licenseManager = adhocWorkflowsLicenseManager;
        this.stateAccessor = stateAccessor;
        this.approvalAccessor = approvalAccessor;
        this.spaceUpgradeAccessor = spaceUpgradeAccessor;
        this.documentActivityUpgradeService = documentActivityUpgradeService;
        this.newLine = System.lineSeparator();
    }

    @Override
    public DebugData populateForTarget(AbstractPage target) {
        String upgradeStatus = null;
        String upgradeDuration = null;
        Long upgradeStartedAt = null;
        Integer upgradeNumErrors = null;
        UpgradeTaskRecord upgradeTaskRecord = this.spaceUpgradeAccessor.getSpaceUpgradeRecord(target.getSpace());
        if (upgradeTaskRecord != null) {
            upgradeStartedAt = upgradeTaskRecord.getStartedAt();
            upgradeStatus = upgradeTaskRecord.getStatus().toString();
            upgradeDuration = upgradeTaskRecord.getDuration();
            upgradeNumErrors = upgradeTaskRecord.getNumErrors();
        }
        return DebugData.builder().latestState(PageStateConverter.convertToXml(this.stateAccessor.getLatestState(target))).latestFinalState(PageStateConverter.convertToXml(this.stateAccessor.getLatestFinalState(target))).statesXml(PageStateConverter.convertToXml(this.stateAccessor.getPageStates(target))).approvalChecksXml(ApprovalChecksConverter.convertToXml(this.approvalAccessor.getApprovalChecks(target))).latestApprovalCheck(ApprovalChecksConverter.convertToXml(this.approvalAccessor.getLatestApprovalCheck(target))).finalApprovalCheck(ApprovalChecksConverter.convertToXml(this.approvalAccessor.getFinalApprovalCheck(target))).preFinalApprovalChecks(this.getPreFinalChecks(target)).activeWorkflowInformation(this.getActiveWorkflowsInformation(target)).upgradeStatus(upgradeStatus).upgradeStartedAt(upgradeStartedAt != null ? new Date(upgradeStartedAt) : null).upgradeDuration(upgradeDuration).upgradeNumErrors(upgradeNumErrors).isPageUpgradePending(this.documentActivityUpgradeService.isPageUpgradePending(target)).pluginInfo(this.getPluginInfo()).build();
    }

    private String getActiveWorkflowsInformation(AbstractPage page) {
        String appName;
        StringBuilder debugsString = new StringBuilder();
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        String string = appName = this.workflowsFeatureManager.isWorkflowsApp() ? "Workflow" : "Approval";
        if (pageWorkflows != null) {
            List<Workflow> workflows = pageWorkflows.getWorkflows();
            debugsString.append("\n\nActive ").append(appName).append("s\n");
            for (Workflow workflow : workflows) {
                debugsString.append(workflow.getName()).append(" |  Labels: ").append(workflow.getLabelNames()).append(" invertLabels: ").append(workflow.isInvertLabels()).append(this.newLine);
            }
            debugsString.append(this.newLine).append(this.newLine).append(appName).append(" Markup\n");
            for (Workflow workflow : workflows) {
                debugsString.append(workflow.getName()).append(this.newLine);
                debugsString.append(workflow.getWorkflowMarkup()).append(this.newLine).append(this.newLine);
            }
        } else {
            debugsString.append(this.newLine).append(this.newLine).append("No Active").append(appName).append("s").append(this.newLine);
        }
        return debugsString.toString();
    }

    private String getPluginInfo() {
        StringBuilder debugsString = new StringBuilder();
        debugsString.append("Plugin and License info\n");
        Plugin plugin = this.pluginAccessor.getEnabledPlugin(this.workflowsFeatureManager.getPluginKey());
        debugsString.append(plugin.getName()).append(" ").append(plugin.getPluginInformation().getVersion()).append(this.newLine);
        PluginLicenseStatus status = this.licenseManager.getLicenseStatus();
        if (StringUtils.isNotBlank((CharSequence)status.getMessageHtml())) {
            debugsString.append(status.getMessageHtml()).append(this.newLine);
        }
        if (StringUtils.isNotBlank((CharSequence)status.getStatus().name())) {
            debugsString.append(status.getStatus().name()).append(this.newLine);
        }
        return debugsString.toString();
    }

    private String getPreFinalChecks(AbstractPage target) {
        List<ApprovalCheck> preFinalApprovalChecks = this.approvalAccessor.getApprovalChecksBeforeLastFinalState(target, null);
        if (preFinalApprovalChecks != null && !preFinalApprovalChecks.isEmpty()) {
            ApprovalCheck[] preFinalChecksArray = preFinalApprovalChecks.toArray(ApprovalCheck.EMPTY_ARRAY);
            return ApprovalChecksConverter.convertToXml(preFinalChecksArray);
        }
        return "";
    }
}

