/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.resources;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsLiteAppRequired;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.restv2.model.RestWorkflow;
import com.comalatech.confluence.workflow.restv2.model.mappers.MapperException;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mappers;
import com.comalatech.confluence.workflow.restv2.resources.AbstractRestResource;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WorkflowsAppRequired
@Path(value="/page")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@PermissionRequired(value={"EDIT"})
public class WorkflowPageResource
extends AbstractRestResource {
    private static final Logger log = LoggerFactory.getLogger(WorkflowPageResource.class);
    private final AdhocWorkflowManager adhocWorkflowManager;

    public WorkflowPageResource(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PageManager pageManager, AdhocWorkflowManager adhocWorkflowManager, WorkflowMarkupManager workflowMarkupManager, WorkflowsFeatureManager workflowsFeatureManager, ComalaI18nBean comalaI18nBean) {
        super(permissionManager, spaceManager, pageManager, workflowMarkupManager, workflowsFeatureManager, comalaI18nBean);
        this.adhocWorkflowManager = adhocWorkflowManager;
    }

    @WorkflowsLiteAppRequired
    @GET
    @Path(value="/{contentId}")
    public Response getPageWorkflow(final @PathParam(value="contentId") Long contentId) {
        return new AbstractRestResource.RestPageCommand(contentId){

            @Override
            public Response doExecute() {
                AbstractPage page = WorkflowPageResource.this.pageManager.getAbstractPage(contentId.longValue());
                if (page == null) {
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                try {
                    Workflow workflow = WorkflowPageResource.this.adhocWorkflowManager.getPageWorkflow(page, true);
                    WorkflowPageResource.this.moveReadAckMacroOutsideState(workflow);
                    RestWorkflow restWorkflow = Mappers.workflowMapper.toRest(workflow);
                    return Response.ok().entity((Object)restWorkflow).build();
                }
                catch (WorkflowException ex) {
                    log.error("Error getting page workflow", (Throwable)ex);
                    return Response.serverError().build();
                }
                catch (MapperException mEx) {
                    log.error("Mapper error trying to restify a workflow", (Throwable)mEx);
                    return Response.serverError().build();
                }
            }
        }.execute();
    }

    @WorkflowsLiteAppRequired
    @PUT
    @Path(value="/{contentId}")
    public Response updatePageWorkflow(@PathParam(value="contentId") Long contentId, RestWorkflow jsonMarkup) {
        return this.savePageWorkflow(contentId, jsonMarkup, false);
    }

    @POST
    @Path(value="/{contentId}")
    public Response createPageWorkflow(@PathParam(value="contentId") Long contentId, RestWorkflow jsonMarkup) {
        return this.savePageWorkflow(contentId, jsonMarkup, true);
    }

    @WorkflowsLiteAppRequired
    private Response savePageWorkflow(final Long contentId, final RestWorkflow jsonMarkup, final boolean setInitialialState) {
        return new AbstractRestResource.RestPageCommand(contentId){

            @Override
            public Response doExecute() {
                AbstractPage page = WorkflowPageResource.this.pageManager.getAbstractPage(contentId.longValue());
                if (page == null) {
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                try {
                    Workflow workflow = Mappers.workflowMapper.fromRest(jsonMarkup);
                    Workflow updatedWorkflow = WorkflowPageResource.this.adhocWorkflowManager.savePageWorkflow(page, workflow, setInitialialState);
                    return Response.ok((Object)Mappers.workflowMapper.toRest(updatedWorkflow)).build();
                }
                catch (WorkflowException ex) {
                    log.error("Error creating/updating page workflow", (Throwable)ex);
                    return Response.serverError().build();
                }
                catch (MapperException mEx) {
                    log.error("Mapper error trying to restify a workflow", (Throwable)mEx);
                    return Response.serverError().build();
                }
            }
        }.execute();
    }
}

