/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;

public class StateCondition
extends Condition {
    protected String[] states;

    public StateCondition(boolean not, String states) {
        super(not);
        this.states = MiscUtils.splitAndTrim(states);
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) throws WorkflowException {
        String stateName;
        PageState latestState = this.getStateAccessor().getLatestState(valueStore.getPage());
        String string = stateName = latestState == null ? null : latestState.getName();
        if (stateName == null) {
            State initialState = valueStore.getPageWorkflows().getInitialState();
            if (initialState == null) {
                return false;
            }
            stateName = initialState.getName();
        }
        for (String state : this.states) {
            if (!state.equalsIgnoreCase(stateName)) continue;
            return true;
        }
        return false;
    }

    public String[] getStates() {
        return this.states;
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        macro.addParameter("state", (Object)((this.not ? "!" : "") + MiscUtils.stringListToCommaSeparatedList(this.states, ",")));
    }

    @Override
    public String toString(ValueStore valueStore) {
        StringBuilder sb = new StringBuilder("state is ");
        if (this.not) {
            sb.append("not ");
        }
        String separator = " " + ComalaI18nBean.getComalaI18nBean().getText("approvalsworkflow.spaceapprovals.condition.or") + " ";
        sb.append(MiscUtils.stringListToCommaSeparatedList(this.states, separator));
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("state is ");
        if (this.not) {
            sb.append("not ");
        }
        sb.append("{").append(MiscUtils.stringListToCommaSeparatedList(this.states, "or")).append("}");
        return sb.toString();
    }

    private StateAccessor getStateAccessor() {
        return PluginContainerManager.getComponent(StateAccessor.class);
    }
}

