/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.comalatech.confluence.workflow.esignatures.model.ESignatureCredentials;
import com.comalatech.workflow.model.Approval;
import com.comalatech.workflow.model.SignatureType;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Approver
implements Serializable,
Comparable,
Approval {
    private static final long serialVersionUID = -1212350387002109104L;
    public static final String APPROVED = "approved";
    public static final String REJECTED = "rejected";
    private String user;
    private String role;
    private Date date;
    private String comment;
    private boolean approved;
    private SignatureType signatureType;
    private ESignatureCredentials.Credentials eSignature;
    private transient String name;

    public Approver() {
    }

    public Approver(String name, String user, String role, Date date, String comment, boolean approved, SignatureType signatureType, ESignatureCredentials.Credentials eSignature) {
        this.user = user;
        this.role = role;
        this.date = date;
        this.comment = comment;
        this.approved = approved;
        this.name = name;
        this.signatureType = signatureType;
        this.eSignature = eSignature;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOutcome() {
        if (this.approved) {
            return APPROVED;
        }
        return REJECTED;
    }

    @Override
    public String getActivityId() {
        return "";
    }

    @Override
    public String getPerformer() {
        return this.getUserName();
    }

    @Override
    public String getUserName() {
        return this.user;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Approver)) {
            if (o instanceof String) {
                return this.user.compareTo((String)o);
            }
            return -1;
        }
        Approver that = (Approver)o;
        int i = this.user.compareTo(that.user);
        if (i != 0) {
            return i;
        }
        if (this.approved == that.approved) {
            return 0;
        }
        if (this.approved) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Approver approver = (Approver)o;
        if (this.approved != approver.approved) {
            return false;
        }
        if (this.comment != null ? !this.comment.equals(approver.comment) : approver.comment != null) {
            return false;
        }
        if (this.date != null ? !this.date.equals(approver.date) : approver.date != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(approver.user) : approver.user != null) {
            return false;
        }
        if (this.role != null ? !this.role.equals(approver.role) : approver.role != null) {
            return false;
        }
        if (this.signatureType != null ? !this.signatureType.equals((Object)approver.signatureType) : approver.signatureType != null) {
            return false;
        }
        return !(this.eSignature != null ? !this.eSignature.equals((Object)approver.eSignature) : approver.eSignature != null);
    }

    public int hashCode() {
        int result = this.user != null ? this.user.hashCode() : 0;
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
        result = 31 * result + (this.approved ? 1 : 0);
        return result;
    }

    public String getUser() {
        return this.user;
    }

    public String getRole() {
        return this.role;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public String getCommentNotNull() {
        if (this.comment == null) {
            return "";
        }
        return this.comment;
    }

    @Override
    public boolean isApproved() {
        return this.approved;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public SignatureType getSignatureType() {
        if (this.signatureType == null) {
            this.signatureType = SignatureType.NONE;
        }
        return this.signatureType;
    }

    public ESignatureCredentials.Credentials getESignature() {
        if (this.eSignature == null) {
            this.eSignature = ESignatureCredentials.Credentials.CONFLUENCE;
        }
        return this.eSignature;
    }

    public void setESignature(ESignatureCredentials.Credentials eSignature) {
        this.eSignature = eSignature;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setDate(Date date) {
        this.date = date;
    }
}

