/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.include;

import com.atlassian.confluence.compat.struts2.actioncontext.ActionContextCompatManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.ContentIncludeStack;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.ExcerptHelper;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.macros.include.imported.ExcerptIncludeMacro;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.model.State;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;

public class WorkflowExcerptIncludeMacro
extends ExcerptIncludeMacro
implements InitializingBean {
    private PageManager pageManager;
    private WorkflowPermissionManager workflowPermissionManager;
    private StateService stateService;
    private WorkflowAccessor workflowAccessor;
    private ApprovalAccessor approvalAccessor;
    private ActionContextCompatManager actionContextCompatManager;

    public void afterPropertiesSet() throws Exception {
        this.excerptHelper = (ExcerptHelper)ContainerManager.getComponent((String)"excerptHelper");
    }

    @Override
    public ContentEntityObject resolveCEO(ContentEntityObject contentEntityObject) throws MacroException {
        AbstractPage page = (AbstractPage)contentEntityObject;
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (pageWorkflows != null && pageWorkflows.isInPagePublishing()) {
            boolean canSeeDraft = this.workflowPermissionManager.canViewDrafts(page, AuthenticatedUserThreadLocal.get());
            State publishedState = this.stateService.getPublishedState(contentEntityObject);
            if (publishedState != null) {
                int version = publishedState.getContentVersion();
                AbstractPage oldPage = this.pageManager.getPageByVersion(page, version);
                try {
                    page = (AbstractPage)page.clone();
                }
                catch (Exception e) {
                    throw new MacroException("Error displaying published content");
                }
                page.setBodyContent(oldPage.getBodyContent());
                page.setVersion(oldPage.getVersion());
            } else if (!canSeeDraft) {
                throw new MacroException("");
            }
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getBodyContent(ContentEntityObject contentEntityObject, String linkTitle, PageContext context) {
        String string;
        if (contentEntityObject == null || !this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)contentEntityObject)) {
            return this.getI18nBean().getText("excerptinclude.error.page-does-not-exists", (Object[])new String[]{StringEscapeUtils.escapeHtml4((String)linkTitle)});
        }
        if (ContentIncludeStack.contains((ContentEntityObject)contentEntityObject)) {
            I18NBean i18nBean = this.getI18nBean();
            String message = i18nBean.getText("excerptinclude.error.recursive.message");
            String contents = i18nBean.getText("excerptinclude.error.recursive.contents", (Object[])new String[]{HtmlUtil.htmlEncode((String)contentEntityObject.getTitle())});
            return RenderUtils.blockError((String)message, (String)contents);
        }
        String existingActionName = null;
        try {
            ContentIncludeStack.push((ContentEntityObject)contentEntityObject);
            PageContext excerptContext = new PageContext(contentEntityObject, context);
            String excerpt = this.excerptHelper.getExcerpt(contentEntityObject);
            DefaultConversionContext excerptConversionContext = new DefaultConversionContext((RenderContext)excerptContext);
            if (this.actionContextCompatManager.getContextMap() != null) {
                existingActionName = this.actionContextCompatManager.getName();
                this.actionContextCompatManager.setName("releaseview");
            }
            excerptConversionContext.setProperty("releaseview", (Object)true);
            string = this.viewRenderer.render(excerpt, (ConversionContext)excerptConversionContext);
        }
        catch (Throwable throwable) {
            ContentIncludeStack.pop();
            if (StringUtils.isNotBlank(existingActionName)) {
                this.actionContextCompatManager.setName(existingActionName);
            }
            throw throwable;
        }
        ContentIncludeStack.pop();
        if (StringUtils.isNotBlank((CharSequence)existingActionName)) {
            this.actionContextCompatManager.setName(existingActionName);
        }
        return string;
    }

    public void setWorkflowAccessor(WorkflowAccessor workflowAccessor) {
        this.workflowAccessor = workflowAccessor;
    }

    public void setWorkflowPermissionManager(WorkflowPermissionManager workflowPermissionManager) {
        this.workflowPermissionManager = workflowPermissionManager;
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setApprovalAccessor(ApprovalAccessor approvalAccessor) {
        this.approvalAccessor = approvalAccessor;
    }

    public void setActionContextCompatManager(@Qualifier(value="actionContextCompatManager") ActionContextCompatManager actionContextCompatManager) {
        this.actionContextCompatManager = actionContextCompatManager;
    }
}

