/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros;

import com.atlassian.confluence.compat.struts2.actioncontext.ActionContextCompatManager;
import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompatManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.helpers.WorkflowHelper;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractAttachmentMacro
extends BaseMacro {
    public static final String PARAM_FILENAME = "attachment";
    public static final String PARAM_VERSION = "version";
    public static final String PARAM_APPROVAL = "approval";
    public static final String PARAM_THUMBNAIL = "thumbnail";
    public static final String PARAM_TIP = "tip";
    public static final String PARAM_ALIAS = "alias";
    private AttachmentManager attachmentManager;
    private ApprovalAccessor approvalAccessor;
    private PermissionManager permissionManager;
    private ActionContextCompatManager actionContextCompatManager;
    private ServletActionContextCompatManager servletActionContextCompatManager;

    public boolean isInline() {
        return true;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public Parameters parseParameters(Map parametersMap) throws MacroException {
        String[] rawParameters = ((String)parametersMap.get(": = | RAW | = :")).split("\\|");
        Parameters parameters = new Parameters();
        StringBuffer properties = new StringBuffer();
        for (int i = 0; i < rawParameters.length; ++i) {
            String rawParameter = rawParameters[i];
            int ix = rawParameter.indexOf(61);
            if (ix < 0 || ix < rawParameter.length() - 1 && rawParameter.indexOf(61, ix + 1) >= 0) {
                if (ix < 0) {
                    if (parameters.fileName == null) {
                        parameters.fileName = this.removeCaret(rawParameter);
                        continue;
                    }
                    if (parameters.alias == null) {
                        if (rawParameter.equalsIgnoreCase(PARAM_THUMBNAIL)) {
                            parameters.thumbnail = true;
                            continue;
                        }
                        parameters.alias = parameters.fileName;
                        parameters.fileName = this.removeCaret(rawParameter);
                        continue;
                    }
                    if (parameters.tip != null) continue;
                    parameters.tip = rawParameter;
                    continue;
                }
                if (properties.length() > 0) {
                    properties.append(',');
                }
                properties.append(rawParameter);
                continue;
            }
            String name = rawParameter.substring(0, ix);
            if (ix >= rawParameter.length()) continue;
            String value = rawParameter.substring(ix + 1);
            if (name.equalsIgnoreCase(PARAM_VERSION)) {
                try {
                    parameters.version = Integer.parseInt(value);
                    continue;
                }
                catch (Exception e) {
                    throw new MacroException("Invalid version " + value);
                }
            }
            if (name.equalsIgnoreCase(PARAM_APPROVAL)) {
                parameters.approvalName = value;
                continue;
            }
            if (properties.length() > 0) {
                properties.append(',');
            }
            properties.append(name).append('=').append(value);
        }
        parameters.properties = properties.toString();
        parameters.fileName = MapUtils.getString(parametersMap, PARAM_FILENAME, parameters.fileName);
        parameters.approvalName = MapUtils.getString(parametersMap, PARAM_APPROVAL);
        if (parametersMap.containsKey(PARAM_VERSION)) {
            parameters.version = MapUtils.getInteger(parametersMap, PARAM_VERSION);
        }
        parameters.tip = MapUtils.getString(parametersMap, PARAM_TIP);
        parameters.alias = MapUtils.getString(parametersMap, PARAM_ALIAS, parameters.alias);
        return parameters;
    }

    protected void loadAttachment(AbstractPage page, Parameters parameters) throws MacroException {
        AbstractPage latestVersion = page.getLatestVersion();
        if (!this.canView((SpaceContentEntityObject)latestVersion)) {
            throw new MacroException(this.makeErrorMessage(parameters));
        }
        if (!StringUtils.isNotBlank((CharSequence)parameters.fileName)) {
            throw new MacroException("filename not set");
        }
        if (parameters.version > 0) {
            parameters.attachment = this.attachmentManager.getAttachment((ContentEntityObject)latestVersion, parameters.fileName, parameters.version);
            if (parameters.attachment == null) {
                throw new MacroException(this.makeErrorMessage(parameters));
            }
        } else {
            parameters.attachment = this.attachmentManager.getAttachment((ContentEntityObject)latestVersion, parameters.fileName);
            if (parameters.attachment == null) {
                throw new MacroException(this.makeErrorMessage(parameters));
            }
            ApprovalCheck latestApproval = this.approvalAccessor.getFinalApprovalCheck(page, parameters.approvalName, WorkflowHelper.getApprovalIdFromActionParams(this.actionContextCompatManager, this.servletActionContextCompatManager));
            if (latestApproval == null) {
                if (StringUtils.isNotBlank((CharSequence)parameters.approvalName)) {
                    throw new MacroException(this.makeErrorMessage(parameters));
                }
            } else {
                parameters.version = latestApproval.getAttachmentVersion(parameters.attachment.getId());
                if (parameters.version > 0) {
                    parameters.attachment = this.attachmentManager.getAttachment((ContentEntityObject)latestVersion, parameters.fileName, parameters.version);
                    if (parameters.attachment == null) {
                        throw new MacroException(this.makeErrorMessage(parameters));
                    }
                }
            }
        }
    }

    private boolean canView(SpaceContentEntityObject entity) {
        return this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)entity);
    }

    private String makeErrorMessage(Parameters parameters) {
        StringBuffer sb = new StringBuffer(parameters.fileName);
        if (parameters.version > 0) {
            sb.append(" v.").append(parameters.version);
        }
        if (StringUtils.isNotBlank((CharSequence)parameters.approvalName)) {
            sb.append(": ").append(parameters.approvalName);
        }
        return sb.toString();
    }

    private String removeCaret(String rawParameter) {
        String fileName = rawParameter.startsWith("^") ? rawParameter.substring(1) : rawParameter;
        return fileName;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setApprovalAccessor(ApprovalAccessor approvalAccessor) {
        this.approvalAccessor = approvalAccessor;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setActionContextCompatManager(@Qualifier(value="actionContextCompatManager") ActionContextCompatManager actionContextCompatManager) {
        this.actionContextCompatManager = actionContextCompatManager;
    }

    public void setServletActionContextCompatManager(@Qualifier(value="servletActionContextCompat") ServletActionContextCompatManager servletActionContextCompatManager) {
        this.servletActionContextCompatManager = servletActionContextCompatManager;
    }

    public class Parameters {
        Attachment attachment;
        String fileName;
        String alias;
        String tip;
        int version;
        String approvalName;
        String properties;
        boolean thumbnail;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }

        public String getTitle() {
            if (StringUtils.isNotBlank((CharSequence)this.tip)) {
                return this.tip;
            }
            if (StringUtils.isNotBlank((CharSequence)this.alias)) {
                return this.alias;
            }
            if (this.version > 0) {
                return this.fileName + " v. " + this.version;
            }
            return this.fileName;
        }

        public String getLinkBody() {
            if (StringUtils.isNotBlank((CharSequence)this.alias)) {
                return this.alias;
            }
            return this.fileName;
        }
    }
}

