/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.states.event.StateTransitionEvent;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalStateListener
extends WorkflowsListener {
    private static final Logger log = LoggerFactory.getLogger(FinalStateListener.class);
    private WorkflowAccessor workflowAccessor;

    public FinalStateListener(@ComponentImport EventPublisher eventPublisher, WorkflowAccessor workflowAccessor) {
        super(eventPublisher);
        this.workflowAccessor = workflowAccessor;
    }

    @EventListener
    public void handleEvent(StateTransitionEvent event) {
        try {
            PageWorkflows pageWorkflows = this.workflowAccessor.getWorkflows(null, (ConfluenceEvent)event);
            if (pageWorkflows == null) {
                return;
            }
            PageState newState = event.getState();
            AbstractPage page = (AbstractPage)event.getContent();
            State state = pageWorkflows.getState(newState.getState());
        }
        catch (WorkflowException e) {
            if (log.isDebugEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            } else {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Error | Exception e) {
            log.error(e.getMessage(), e);
        }
    }
}

