/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.esignatures.validator;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.workflow.esignatures.model.TokenExpiryDateUpdateRequest;
import com.comalatech.confluence.workflow.esignatures.service.TOTPHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.commons.lang3.StringUtils;

public class ESignatureValidator {
    private final TOTPHelper totpHelper;
    private final UserAccessor userAccessor;
    private final ComalaI18nBean comalaI18nBean;
    private static final String EMAIL_HTML_KEY = "comalatech.esignatures.signing.otp.error.email.html";
    private static final String USER_HTML_KEY = "comalatech.esignatures.signing.otp.error.user.html";
    private static final String EMAIL_VALIDATION_KEY = "comalatech.esignatures.signing.otp.error.email";
    private static final String USER_VALIDATION_KEY = "comalatech.esignatures.signing.otp.error.user";
    private static final String TOKEN_VALIDATION_KEY = "comalatech.esignatures.signing.otp.error.token";
    private static final String TOKEN_HTML_KEY = "comalatech.esignatures.signing.otp.error.token.html";
    private static final String EXPIRY_UPDATE_HTML_KEY = "comalatech.esignatures.signing.otp.error.expiry.html";
    private static final String INVALID_EXPIRY_UPDATE_REQUEST = "comalatech.esignatures.signing.otp.error.update.expiry";
    private static final String EMPTY_USER_KEY = "comalatech.esignatures.signing.otp.error.delete.token";
    private String error;

    public ESignatureValidator(TOTPHelper totpHelper, UserAccessor userAccessor, ComalaI18nBean comalaI18nBean) {
        this.totpHelper = totpHelper;
        this.userAccessor = userAccessor;
        this.comalaI18nBean = comalaI18nBean;
    }

    public boolean isEmailValid(ConfluenceUser confluenceUser, String email) {
        if (!confluenceUser.getEmail().equalsIgnoreCase(email)) {
            this.setError(this.comalaI18nBean.getText(EMAIL_HTML_KEY, new String[]{this.comalaI18nBean.getText(EMAIL_VALIDATION_KEY)}));
            return false;
        }
        return true;
    }

    public boolean isUserValid(ConfluenceUser confluenceUser, String userKey) {
        if (!confluenceUser.getKey().getStringValue().equals(userKey)) {
            this.setError(this.comalaI18nBean.getText(USER_HTML_KEY, new String[]{this.comalaI18nBean.getText(USER_VALIDATION_KEY)}));
            return false;
        }
        return true;
    }

    public boolean isUserValid(String userKey) {
        if (StringUtils.isBlank((CharSequence)userKey)) {
            this.setError(this.comalaI18nBean.getText(USER_HTML_KEY, new String[]{this.comalaI18nBean.getText(EMPTY_USER_KEY)}));
            return false;
        }
        ConfluenceUser existingUserByKey = this.userAccessor.getExistingUserByKey(new UserKey(userKey));
        if (existingUserByKey == null) {
            this.setError(this.comalaI18nBean.getText(USER_HTML_KEY, new String[]{this.comalaI18nBean.getText(USER_VALIDATION_KEY)}));
            return false;
        }
        return true;
    }

    public boolean isTokenValid(String secret, String code) {
        if (!this.totpHelper.isValid(secret, code)) {
            this.setError(this.comalaI18nBean.getText(TOKEN_HTML_KEY, new String[]{this.comalaI18nBean.getText(TOKEN_VALIDATION_KEY)}));
            return false;
        }
        return true;
    }

    public boolean isInvalidValidUpdateRequest(TokenExpiryDateUpdateRequest request) {
        if (request == null || !request.isValidRequest()) {
            this.setError(this.comalaI18nBean.getText(EXPIRY_UPDATE_HTML_KEY, new String[]{this.comalaI18nBean.getText(INVALID_EXPIRY_UPDATE_REQUEST)}));
            return true;
        }
        return false;
    }

    private String convertXHtmlToJson(String xHtml) {
        String errorStart = "<div class=\"error\">";
        String errorEnd = "</div>";
        if (StringUtils.contains((CharSequence)xHtml, (CharSequence)"<div class=\"error\">")) {
            String[] errorsInHtml = StringUtils.substringsBetween((String)xHtml, (String)"<div class=\"error\">", (String)"</div>");
            String errorTitle = StringUtils.substringBetween((String)xHtml, (String)"", (String)"<div class=\"error\">").replace("<br/>", "");
            JsonObject jsonResponse = new JsonObject();
            JsonArray errorList = new JsonArray();
            for (String error : errorsInHtml) {
                JsonObject jsonError = new JsonObject();
                jsonError.addProperty("type", "error");
                jsonError.addProperty("title", errorTitle);
                jsonError.addProperty("html", error);
                errorList.add((JsonElement)jsonError);
            }
            jsonResponse.add("messages", (JsonElement)errorList);
            return jsonResponse.toString();
        }
        return xHtml;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getJSONError() {
        return this.convertXHtmlToJson(this.error);
    }

    public static interface TextRetriever {
        public String getText(String var1);

        public String getText(String var1, Object[] var2);
    }
}

