/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.esignatures.service;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.encryption.AESEncryption;
import com.comalatech.confluence.encryption.AESEncryptionException;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.esignatures.ao.SigningRecordDeleteCriteria;
import com.comalatech.confluence.workflow.esignatures.ao.accesor.SigningTokenRecordAccessor;
import com.comalatech.confluence.workflow.esignatures.ao.entity.BaseSigningTokenRecord;
import com.comalatech.confluence.workflow.esignatures.events.OneTimePasswordSigningConfigRequested;
import com.comalatech.confluence.workflow.esignatures.mapper.SigningTokenRecordMapper;
import com.comalatech.confluence.workflow.esignatures.model.SigningToken;
import com.comalatech.confluence.workflow.esignatures.model.SigningTokenRegistry;
import com.comalatech.confluence.workflow.esignatures.model.SigningTokenStatus;
import com.comalatech.confluence.workflow.esignatures.model.TOTPModel;
import com.comalatech.confluence.workflow.esignatures.model.UserEsignatureData;
import com.comalatech.confluence.workflow.esignatures.service.ESignaturesService;
import com.comalatech.confluence.workflow.esignatures.service.TOTPHelper;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ESignaturesServiceImpl
implements ESignaturesService {
    private static final Logger log = LoggerFactory.getLogger(ESignaturesServiceImpl.class);
    private final SigningTokenRecordAccessor signingTokenRecordAccessor;
    private final ComalaPropertiesSetManager contentPropertyManager;
    private final PersonalInformationManager personalInformationManager;
    private final UserAccessor userAccessor;
    private final EventPublisher eventPublisher;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final SystemInformationService systemInformationService;
    private final TOTPHelper totpHelper;
    public static final String SIGNING_TOKEN_PROPERTY = "com.comalatech.esignatures.signing";

    public ESignaturesServiceImpl(SigningTokenRecordAccessor signingTokenRecordAccessor, ComalaPropertiesSetManager contentPropertyManager, PersonalInformationManager personalInformationManager, EventPublisher eventPublisher, UserAccessor userAccessor, WorkflowConfigurationManager workflowConfigurationManager, SystemInformationService systemInformationService) {
        this.signingTokenRecordAccessor = signingTokenRecordAccessor;
        this.contentPropertyManager = contentPropertyManager;
        this.personalInformationManager = personalInformationManager;
        this.userAccessor = userAccessor;
        this.eventPublisher = eventPublisher;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.systemInformationService = systemInformationService;
        this.totpHelper = new TOTPHelper();
    }

    @Override
    public SigningTokenStatus getSigningTokenStatus(String userKey) throws Exception {
        BaseSigningTokenRecord baseSigningTokenRecord = this.signingTokenRecordAccessor.get(userKey);
        if (baseSigningTokenRecord == null) {
            SigningToken signingToken = this.getSigningToken(userKey);
            if (signingToken == null) {
                return this.initSigningSetupState();
            }
            if (TimerUtils.isDateExpired(signingToken.getExpiryTimestamp())) {
                return this.resetSigningTokenSetup(userKey);
            }
            return this.userEmailValidationState(signingToken);
        }
        if (TimerUtils.isDateExpired(baseSigningTokenRecord.getExpiryTimestamp())) {
            this.purgeSigningToken(userKey);
            return this.resetSigningTokenSetup(userKey);
        }
        return this.finalSigningSetupState(baseSigningTokenRecord);
    }

    @Override
    public SigningToken createSigningToken(String userKey) throws Exception {
        ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(userKey));
        TOTPModel totpModel = this.totpHelper.generateSecret(confluenceUser.getEmail(), this.workflowConfigurationManager.getWorkflowVersionName());
        SigningToken signingToken = new SigningToken(userKey, totpModel.getSecret(), DateTime.now().getMillis(), UUID.randomUUID().toString(), DateTime.now().plusMinutes(15).getMillis(), false, totpModel.getOtpauth(), totpModel.getDigits(), totpModel.getPeriod(), totpModel.getAlgorithm().getFriendlyName());
        this.persistTemporarySigningToken(userKey, signingToken);
        this.eventPublisher.publish((Object)new OneTimePasswordSigningConfigRequested(this, signingToken));
        return signingToken;
    }

    @Override
    public SigningToken getSigningToken(String userKey) throws IOException, AESEncryptionException {
        SigningToken signingToken = null;
        ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(userKey));
        PersonalInformation pi = this.personalInformationManager.getOrCreatePersonalInformation((User)confluenceUser);
        String signingTokenJson = this.contentPropertyManager.getTextProperty((ContentEntityObject)pi, SIGNING_TOKEN_PROPERTY);
        if (signingTokenJson != null) {
            ObjectMapper mapper = new ObjectMapper();
            signingToken = (SigningToken)mapper.readValue(signingTokenJson, SigningToken.class);
            this.decryptSecretKeyContent(signingToken);
        }
        return signingToken;
    }

    @Override
    public BaseSigningTokenRecord getSigningTokenRecord(String userKey) throws AESEncryptionException {
        BaseSigningTokenRecord baseSigningTokenRecord = this.signingTokenRecordAccessor.get(userKey);
        if (baseSigningTokenRecord != null) {
            this.decryptSecretKeyRecord(baseSigningTokenRecord);
        }
        return baseSigningTokenRecord;
    }

    @Override
    public void persistSigningToken(SigningToken token) throws AESEncryptionException {
        this.encryptSecretKeyContent(token);
        BaseSigningTokenRecord baseSigningTokenRecord = SigningTokenRecordMapper.modelToRecord(token);
        this.signingTokenRecordAccessor.save(baseSigningTokenRecord);
    }

    @Override
    public void persistTemporarySigningToken(String userKey, SigningToken token) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String signing = mapper.writeValueAsString((Object)this.encryptSecretKeyContent(token));
        ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(userKey));
        PersonalInformation pi = this.personalInformationManager.getOrCreatePersonalInformation((User)confluenceUser);
        this.contentPropertyManager.setTextProperty((ContentEntityObject)pi, SIGNING_TOKEN_PROPERTY, signing);
    }

    @Override
    public List<UserEsignatureData> getUserESignatureData() {
        List<BaseSigningTokenRecord> allTokenRecords = this.signingTokenRecordAccessor.getAll();
        return allTokenRecords.stream().map(this::recordToUserEsignatureData).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void purgeSigningToken(String userKey) {
        SigningRecordDeleteCriteria deleteCriteria = new SigningRecordDeleteCriteria();
        deleteCriteria.setUserKey(userKey);
        this.signingTokenRecordAccessor.delete(deleteCriteria);
    }

    @Override
    public void updateSigningTokeRecord(SigningTokenRegistry tokenRegistry) {
        BaseSigningTokenRecord record = SigningTokenRecordMapper.signingTokenRegistryToRecord(tokenRegistry);
        this.signingTokenRecordAccessor.update(record);
    }

    @Override
    public void purgeTemporarySigningToken(String userKey) {
        ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(userKey));
        PersonalInformation pi = this.personalInformationManager.getOrCreatePersonalInformation((User)confluenceUser);
        this.contentPropertyManager.removeProperty((ContentEntityObject)pi, SIGNING_TOKEN_PROPERTY);
    }

    private SigningTokenStatus resetSigningTokenSetup(String userKey) {
        SigningTokenStatus signingTokenStatus = new SigningTokenStatus();
        ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(userKey));
        PersonalInformation pi = this.personalInformationManager.getOrCreatePersonalInformation((User)confluenceUser);
        this.contentPropertyManager.removeProperty((ContentEntityObject)pi, SIGNING_TOKEN_PROPERTY);
        signingTokenStatus.setStatus(SigningTokenStatus.Status.NONE);
        signingTokenStatus.setSigningToken(null);
        return signingTokenStatus;
    }

    private SigningTokenStatus userEmailValidationState(SigningToken signingToken) {
        SigningTokenStatus signingTokenStatus = new SigningTokenStatus();
        if (!signingToken.getValidate().booleanValue()) {
            signingTokenStatus.setStatus(SigningTokenStatus.Status.EMAIL_SENT);
            signingTokenStatus.setSigningToken(null);
        } else {
            signingTokenStatus.setStatus(SigningTokenStatus.Status.TOKEN_VALIDATION);
            signingTokenStatus.setSigningToken(SigningTokenRecordMapper.modelToFirstValidationResponse(signingToken));
        }
        return signingTokenStatus;
    }

    private SigningTokenStatus initSigningSetupState() {
        SigningTokenStatus signingTokenStatus = new SigningTokenStatus();
        signingTokenStatus.setStatus(SigningTokenStatus.Status.NONE);
        signingTokenStatus.setSigningToken(null);
        return signingTokenStatus;
    }

    private SigningTokenStatus finalSigningSetupState(BaseSigningTokenRecord baseSigningTokenRecord) {
        SigningTokenStatus signingTokenStatus = new SigningTokenStatus();
        signingTokenStatus.setStatus(SigningTokenStatus.Status.SUCCESS);
        signingTokenStatus.setSigningToken(SigningTokenRecordMapper.recordToModel(baseSigningTokenRecord));
        ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(baseSigningTokenRecord.getUserKey()));
        PersonalInformation pi = this.personalInformationManager.getOrCreatePersonalInformation((User)confluenceUser);
        this.contentPropertyManager.removeProperty((ContentEntityObject)pi, SIGNING_TOKEN_PROPERTY);
        return signingTokenStatus;
    }

    private UserEsignatureData recordToUserEsignatureData(BaseSigningTokenRecord record) {
        if (record != null) {
            UserEsignatureData response = new UserEsignatureData();
            try {
                UserKey userKey = new UserKey(record.getUserKey());
                ConfluenceUser user = this.userAccessor.getUserByKey(userKey);
                ProfilePictureInfo userProfilePicture = this.userAccessor.getUserProfilePicture((User)user);
                response.setUserName(user.getFullName());
                response.setUserImage(userProfilePicture.getUriReference());
            }
            catch (Exception e) {
                log.warn("There has been an error retrieving user {}", (Object)record.getUserKey(), (Object)e);
            }
            response.setUserKey(record.getUserKey());
            response.setLastAttempt(record.getLastSuccess());
            response.setCreationDate(record.getCreatedTimestamp());
            response.setFailedAttempts(record.getFailedAttempts() == null ? 0 : record.getFailedAttempts());
            response.setExpirationDate(record.getExpiryTimestamp());
            return response;
        }
        return null;
    }

    private SigningToken encryptSecretKeyContent(SigningToken signingToken) throws AESEncryptionException {
        String encryptedSecretKey = AESEncryption.encrypt(signingToken.getSecretKey(), this.systemInformationService.getConfluenceInfo().getServerId());
        signingToken.setSecretKey(encryptedSecretKey);
        signingToken.setOtpAuth(signingToken.getOtpAuth().replace(StringUtils.substringBetween((String)signingToken.getOtpAuth(), (String)"secret=", (String)"&issuer"), encryptedSecretKey));
        return signingToken;
    }

    private SigningToken decryptSecretKeyContent(SigningToken signingToken) throws AESEncryptionException {
        String decryptedSecretKey = AESEncryption.decrypt(signingToken.getSecretKey(), this.systemInformationService.getConfluenceInfo().getServerId());
        signingToken.setSecretKey(decryptedSecretKey);
        signingToken.setOtpAuth(signingToken.getOtpAuth().replace(StringUtils.substringBetween((String)signingToken.getOtpAuth(), (String)"secret=", (String)"&issuer"), decryptedSecretKey));
        return signingToken;
    }

    private BaseSigningTokenRecord decryptSecretKeyRecord(BaseSigningTokenRecord baseSigningTokenRecord) throws AESEncryptionException {
        String decryptedSecretKey = AESEncryption.decrypt(baseSigningTokenRecord.getSecretKey(), this.systemInformationService.getConfluenceInfo().getServerId());
        baseSigningTokenRecord.setSecretKey(decryptedSecretKey);
        return baseSigningTokenRecord;
    }
}

