/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.descriptors;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowModuleDescriptor
extends AbstractModuleDescriptor<Workflow> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowModuleDescriptor.class);
    private String blueprintKey;
    private String workflowMarkup;
    private final AdhocWorkflowManager adhocWorkflowManager;

    public WorkflowModuleDescriptor(ModuleFactory moduleFactory, AdhocWorkflowManager adhocWorkflowManager) {
        super(moduleFactory);
        this.adhocWorkflowManager = adhocWorkflowManager;
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.workflowMarkup = element.getData().toString();
        this.blueprintKey = this.getAttribute(element, "blueprintkey");
    }

    private String getAttribute(Element element, String attributeName) {
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null || !StringUtils.isNotBlank((CharSequence)attribute.getValue())) {
            return null;
        }
        return attribute.getValue();
    }

    public String getBlueprintKey() {
        return this.blueprintKey;
    }

    public Workflow getModule() {
        try {
            Workflow workflow = this.adhocWorkflowManager.parseWorkflowMarkup(this.workflowMarkup);
            if (workflow != null) {
                workflow.setKey(this.getCompleteKey());
                workflow.setName(this.getName());
                workflow.setBlueprintKey(this.blueprintKey);
                return workflow;
            }
        }
        catch (WorkflowException e) {
            log.error("Invalid workflow " + this.getCompleteKey());
        }
        return null;
    }
}

