/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.infrastructure.persistence.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.contracts.WorkflowsStoreGateway;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class ClusterJsonCachedStoreGateway
implements WorkflowsStoreGateway<String, String> {
    private final String CACHE_NAME = ClusterJsonCachedStoreGateway.class.getName() + "_FOR_MARKUP_ANALYTICS";
    private final Cache<String, String> cache;

    public ClusterJsonCachedStoreGateway(@ComponentImport CacheManager cacheManager) {
        CacheSettings clusterCacheSetting = new CacheSettingsBuilder().remote().replicateViaCopy().maxEntries(1000).expireAfterWrite(24L, EVICTION_UNIT).build();
        this.cache = cacheManager.getCache(this.CACHE_NAME, null, clusterCacheSetting);
    }

    @Override
    public boolean persist(String key, String workflow) {
        return this.cache.putIfAbsent((Object)key, (Object)workflow) != null;
    }

    @Override
    public boolean keyExist(String key) {
        return this.cache.containsKey((Object)key);
    }

    @Override
    public Stream<String> getAll() {
        return (Stream)this.cache.getKeys().parallelStream().map(arg_0 -> this.cache.get(arg_0)).sequential();
    }

    @Override
    public void removeAll() {
        this.cache.removeAll();
    }
}

