/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup;

import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.analytics.usecases.workflowsmarkup.contracts.WorkflowsStoreGateway;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class StoreWorkflowsUseCase {
    private final WorkflowsStoreGateway<String, String> workflowsStoreGateway;
    private final WorkflowMarkupManager workflowMarkupManager;
    private final WorkflowsFeatureManager workflowsFeatureManager;

    public StoreWorkflowsUseCase(WorkflowsStoreGateway<String, String> workflowsStoreGateway, WorkflowMarkupManager workflowMarkupManager, WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsStoreGateway = workflowsStoreGateway;
        this.workflowMarkupManager = workflowMarkupManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    public void create(Workflow workflow) {
        String workflowId;
        if (workflow != null && this.workflowsFeatureManager.isWorkflowsApp() && !this.workflowsStoreGateway.keyExist(workflowId = this.getUniqueKey(workflow.getName(), workflow.getContainerSpaceKey()))) {
            String workflowJson = this.workflowMarkupManager.convertToJson(workflow);
            this.workflowsStoreGateway.persist(workflowId, workflowJson);
        }
    }

    public String getUniqueKey(String workflowName, String workflowSpace) {
        return workflowName + "_" + (String)StringUtils.defaultIfBlank((CharSequence)workflowSpace, (CharSequence)"0");
    }
}

