/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.events.MigrationAssessmentScreenEvent;
import com.comalatech.confluence.readack.events.ReadAckDueDateChangeEventImpl;
import com.comalatech.confluence.readack.events.stats.ReadAckNewRequest;
import com.comalatech.confluence.readack.events.stats.ReadAckSupressReadConfirmation;
import com.comalatech.confluence.states.event.UserSelectedStateEvent;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.analytics.DispatcherAnalyticsManager;
import com.comalatech.confluence.workflow.analytics.ReadAckInformationGatherer;
import com.comalatech.confluence.workflow.analytics.catalog.BandanaKeysCatalog;
import com.comalatech.confluence.workflow.events.ApprovalRoleAssignmentEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.GlobalWorkflowLinkedToCategoryEvent;
import com.comalatech.confluence.workflow.events.PageApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowEditedEventImpl;
import com.comalatech.confluence.workflow.events.blogpost.BlogPostWorkflowAddedEventImpl;
import com.comalatech.confluence.workflow.events.page.PageWorkflowAddedEventImpl;
import com.comalatech.workflow.event.TaskAssignEvent;
import com.comalatech.workflow.event.TaskCompleteEvent;
import com.comalatech.workflow.event.approval.ApprovalApprovedEvent;
import com.comalatech.workflow.event.approval.ApprovalAssignedEvent;
import com.comalatech.workflow.event.approval.ApprovalRejectedEvent;
import com.comalatech.workflow.event.readack.ReadAcknowledgedEvent;
import com.comalatech.workflow.model.SignatureType;
import java.time.Clock;
import org.apache.commons.lang3.StringUtils;

public class StatsListener
extends WorkflowsListener {
    private DispatcherAnalyticsManager dispatcherAnalyticsManager;
    private ReadAckInformationGatherer readAckInformationGatherer;

    public StatsListener(@ComponentImport EventPublisher eventPublisher, DispatcherAnalyticsManager dispatcherAnalyticsManager, ReadAckInformationGatherer readAckInformationGatherer) {
        super(eventPublisher);
        this.dispatcherAnalyticsManager = dispatcherAnalyticsManager;
        this.readAckInformationGatherer = readAckInformationGatherer;
    }

    @EventListener
    public void onTaskAssigned(TaskAssignEvent event) {
        if (event.getTask() != null && event.getTask().getLastAssignment() != null && StringUtils.isNotBlank((CharSequence)event.getTask().getLastAssignment().getAssignee())) {
            this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_TASK_ASSIGNED_KEY);
        }
    }

    @EventListener
    public void onTaskCompleted(TaskCompleteEvent event) {
        if (event.getTask() != null && event.getTask().isCompleted()) {
            this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_TASK_COMPLETED_KEY);
        }
    }

    @EventListener
    public void onReadAcknowledged(ReadAcknowledgedEvent event) {
        this.readAckInformationGatherer.setReadAckTimeStampStat(Clock.systemDefaultZone(), "latestReadConfirmation");
    }

    @EventListener
    public void onApprovalRoleAssigned(ApprovalRoleAssignmentEvent event) {
        this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_APPROVAL_ROLE_ASSIGNED_KEY);
    }

    @EventListener
    public void onBlogPostApprovalWithCredentials(BlogPostApprovalApproveEvent event) {
        if (!event.isPartial() && event.getApproval() != null && event.getApproval().getSignatureType() != null && !SignatureType.NONE.equals((Object)event.getApproval().getSignatureType())) {
            this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_APPROVAL_WITH_CREDENTIALS_KEY);
        }
    }

    @EventListener
    public void onPageApprovalWithCredentials(PageApprovalApproveEvent event) {
        if (!event.isPartial() && event.getApproval() != null && event.getApproval().getSignatureType() != null && !SignatureType.NONE.equals((Object)event.getApproval().getSignatureType())) {
            this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_APPROVAL_WITH_CREDENTIALS_KEY);
        }
    }

    @EventListener
    public void onReadAckDueDateChange(ReadAckDueDateChangeEventImpl event) {
        this.readAckInformationGatherer.setReadAckTimeStampStat(Clock.systemDefaultZone(), "latestDueDateModified");
    }

    @EventListener
    public void onNewReadAckRequest(ReadAckNewRequest event) {
        this.readAckInformationGatherer.setReadAckTimeStampStat(Clock.systemDefaultZone(), "latestNewReadAckRequestSent");
    }

    @EventListener
    public void onReadAckSuppressReadAck(ReadAckSupressReadConfirmation event) {
        this.readAckInformationGatherer.setReadAckTimeStampStat(Clock.systemDefaultZone(), "latestSuppressReadAckUnticked");
    }

    @EventListener
    public void onGlobalWorkflowLinkedToCategory(GlobalWorkflowLinkedToCategoryEvent event) {
        this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_WORKFLOW_LINKED_TO_SPACE_CATEGORY_KEY);
    }

    @EventListener
    public void onApprovalAssignedEvent(ApprovalAssignedEvent event) {
        this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_APPROVAL_ASSIGNED_KEY);
    }

    @EventListener
    public void onApprovalOrRejectApproveEvent(ApprovalApprovedEvent event) {
        this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_APPROVED_OR_REJECTED_KEY);
        if (event.getAbstractPage() != null) {
            this.dispatcherAnalyticsManager.setAnalyticsEntry(BandanaKeysCatalog.LATEST_CONTENT_APPROVED_OR_REJECTED_KEY, event.getAbstractPage().getIdAsString());
        }
    }

    @EventListener
    public void onApprovalOrRejectApproveEvent(ApprovalRejectedEvent event) {
        this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_APPROVED_OR_REJECTED_KEY);
        if (event.getAbstractPage() != null) {
            this.dispatcherAnalyticsManager.setAnalyticsEntry(BandanaKeysCatalog.LATEST_CONTENT_APPROVED_OR_REJECTED_KEY, event.getAbstractPage().getIdAsString());
        }
    }

    @EventListener
    public void onStateSelectEvent(UserSelectedStateEvent event) {
        this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_STATE_SELECTED_KEY);
    }

    @EventListener
    public void onSpaceWorkflowSaved(SpaceWorkflowEditedEventImpl event) {
        this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_SPACE_WORKFLOW_SAVED_KEY);
    }

    @EventListener
    public void onPageWorkflowSaved(PageWorkflowAddedEventImpl event) {
        this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_PAGE_WORKFLOW_SAVED_KEY);
    }

    @EventListener
    public void onBlogPostWorkflowSaved(BlogPostWorkflowAddedEventImpl event) {
        this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_PAGE_WORKFLOW_SAVED_KEY);
    }

    @EventListener
    public void onMigrationAssessmentScreenEvent(MigrationAssessmentScreenEvent event) {
        this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_MIGRATION_ASSESSMENT_TOOL_ACCESS);
    }
}

