/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.analytics.StatField;
import com.comalatech.confluence.readack.service.ReadAckSearchService;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ReadAckInformationGatherer {
    public static final String STAT_READ_ACK_MACRO_TOTAL = "readAckMacroTotal";
    public static final String STAT_READ_ACK_PAGES_TOTAL = "activeReadAcks";
    public static final String LATEST_READ_CONFIRMATION = "latestReadConfirmation";
    public static final String LATEST_READERS_MODIFIED = "latestReadersModified";
    public static final String LATEST_DUE_DATE_MODIFIED = "latestDueDateModified";
    public static final String LATEST_NEW_REQUEST_SEND = "latestNewReadAckRequestSent";
    public static final String LATEST_SUPPRESS_READ_ACK_UNTICKED = "latestSuppressReadAckUnticked";
    public static final String STAT_READ_ACK_PAGE_STANDALONE_TOTAL = "standloneReadAckPages";
    public static final String STAT_READ_ACK_SPACE_STANDALONE_TOTAL = "standloneReadAckSpaces";
    private final ReadAckSearchService readAckSearchService;
    private final BandanaManager bandanaManager;

    public ReadAckInformationGatherer(ReadAckSearchService readAckSearchService, @ComponentImport BandanaManager bandanaManager) {
        this.readAckSearchService = readAckSearchService;
        this.bandanaManager = bandanaManager;
    }

    private StatField obtainCurrentWorkflowsWithReadAck() {
        return new StatField(STAT_READ_ACK_MACRO_TOTAL, () -> this.readAckSearchService.getNumberOfWorkflowsWithReadAck());
    }

    private StatField obtainNumberOfPagesWithReadAck() {
        return new StatField(STAT_READ_ACK_PAGES_TOTAL, () -> this.readAckSearchService.getNumberOfPagesWithReadAck());
    }

    private StatField obtainCurrentStandaloneReadAckPages() {
        return new StatField(STAT_READ_ACK_PAGE_STANDALONE_TOTAL, () -> this.readAckSearchService.getNumberOfPagesWithStandaloneReadAck());
    }

    private StatField obtainCurrentStandaloneReadAckSpaces() {
        return new StatField(STAT_READ_ACK_SPACE_STANDALONE_TOTAL, () -> this.readAckSearchService.getSpacesWithStandaloneReadAck());
    }

    public List<StatField> getAnalyticsFields() {
        ArrayList<StatField> fields = new ArrayList<StatField>();
        fields.add(this.obtainCurrentWorkflowsWithReadAck());
        fields.add(this.obtainNumberOfPagesWithReadAck());
        fields.add(this.obtainCurrentStandaloneReadAckPages());
        fields.add(this.obtainCurrentStandaloneReadAckSpaces());
        fields.add(this.obtainLatestTimestampAsStatField(LATEST_READ_CONFIRMATION));
        fields.add(this.obtainLatestTimestampAsStatField(LATEST_READERS_MODIFIED));
        fields.add(this.obtainLatestTimestampAsStatField(LATEST_DUE_DATE_MODIFIED));
        fields.add(this.obtainLatestTimestampAsStatField(LATEST_NEW_REQUEST_SEND));
        fields.add(this.obtainLatestTimestampAsStatField(LATEST_SUPPRESS_READ_ACK_UNTICKED));
        return fields;
    }

    public void setReadAckTimeStampStat(Clock time, String bandanaKey) {
        Objects.requireNonNull(time, "Time cannot be null");
        Objects.requireNonNull(bandanaKey, "Bandana Key cannot be null");
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), bandanaKey, (Object)time.millis());
    }

    private <T> Optional<T> getReadAckTimeStampStat(String bandanaKey) {
        Object bandanaEntry = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), bandanaKey);
        return Optional.ofNullable(bandanaEntry);
    }

    private StatField obtainLatestTimestampAsStatField(String key) {
        Optional latestTimestamp = this.getReadAckTimeStampStat(key);
        return new StatField(key, () -> latestTimestamp.orElse(0L));
    }
}

