/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.comalatech.confluence.analytics.DefaultAnalyticsManager;
import com.comalatech.confluence.analytics.StatField;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.analytics.ESignatureStatsGatherer;
import com.comalatech.confluence.workflow.analytics.ReadAckInformationGatherer;
import com.comalatech.confluence.workflow.analytics.UpgradeStatsGatherer;
import com.comalatech.confluence.workflow.analytics.WorkflowStatsGather;
import com.comalatech.confluence.workflow.analytics.catalog.BandanaKeysCatalog;
import com.comalatech.confluence.workflow.analytics.catalog.StatsCatalog;
import com.comalatech.confluence.workflow.service.ApprovalsSearchService;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CommonAnalyticsManager
extends DefaultAnalyticsManager
implements ApplicationContextAware,
InitializingBean {
    protected final ApprovalsSearchService approvalsSearchService;
    protected final SpaceManager spaceManager;
    protected final WorkflowsFeatureManager workflowsFeatureManager;
    protected WorkflowStatsGather workflowStatsGather;
    protected final ReadAckInformationGatherer readAckInformationGatherer;
    protected final ESignatureStatsGatherer eSignatureStatsGatherer;
    protected final WorkflowStatisticsManager workflowStatisticsManager;
    protected final UpgradeStatsGatherer upgradeStatsGatherer;
    private ApplicationContext applicationContext;

    public CommonAnalyticsManager(@ComponentImport BandanaManager bandanaManager, @ComponentImport ConfluenceSidManager confluenceSidManager, @ComponentImport SystemInformationService systemInformationService, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport SearchManager searchManager, ApprovalsSearchService approvalsSearchService, @ComponentImport SpaceManager spaceManager, WorkflowsFeatureManager workflowsFeatureManager, ReadAckInformationGatherer readAckInformationGatherer, ESignatureStatsGatherer eSignatureStatsGatherer, WorkflowStatisticsManager workflowStatisticsManager, UpgradeStatsGatherer upgradeStatsGatherer) {
        super(bandanaManager, confluenceSidManager, systemInformationService, pluginAccessor, pluginLicenseManager, searchManager);
        this.approvalsSearchService = approvalsSearchService;
        this.spaceManager = spaceManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.readAckInformationGatherer = readAckInformationGatherer;
        this.eSignatureStatsGatherer = eSignatureStatsGatherer;
        this.workflowStatisticsManager = workflowStatisticsManager;
        this.upgradeStatsGatherer = upgradeStatsGatherer;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.workflowStatisticsManager != null) {
            this.setEnabled(this.workflowStatisticsManager.isStatsEnabled());
        }
        this.workflowStatsGather = (WorkflowStatsGather)this.applicationContext.getBean(WorkflowStatsGather.class);
    }

    @Override
    protected StatField[] getExtendedStatFields() {
        ArrayList<StatField> fields = new ArrayList<StatField>();
        fields.add(new StatField(StatsCatalog.STAT_WORKFLOW_REPORTER_MACRO_TOTAL, () -> this.countPagesWithMacro("workflow-reporter")));
        fields.add(new StatField(StatsCatalog.STAT_WORKFLOW_REPORT_MACRO_TOTAL, () -> this.countPagesWithMacro("workflowreport")));
        fields.add(new StatField(StatsCatalog.STAT_PAGE_ACTIVITY_MACRO_TOTAL, () -> this.countPagesWithMacro("pageactivity")));
        fields.add(new StatField(StatsCatalog.STAT_PAGE_STATUS_MACRO_TOTAL, () -> this.countPagesWithMacro("pagestatus")));
        fields.add(new StatField(StatsCatalog.STAT_ACTIVE_PAGES, this::getActivePages));
        fields.add(new StatField(StatsCatalog.STAT_ACTIVE_SPACES, this::getActiveSpaces));
        fields.add(new StatField("totalSpaces", this::getTotalSpaces));
        fields.add(new StatField("totalPages", this::getTotalPages));
        fields.add(new StatField(StatsCatalog.STAT_DOCUMENT_STATES_MACRO_TOTAL, () -> this.countPagesWithMacro("document-states-report")));
        fields.add(new StatField(StatsCatalog.STAT_DOCUMENT_STATS_MACRO_TOTAL, () -> this.countPagesWithMacro("document-stats-report")));
        if (this.workflowsFeatureManager.isWorkflowsApp()) {
            fields.add(new StatField(StatsCatalog.STAT_LATEST_APPROVAL_ROLE_ASSIGNED, () -> this.getTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_APPROVAL_ROLE_ASSIGNED_KEY)));
            fields.add(new StatField(StatsCatalog.STAT_LATEST_TASK_COMPLETED, () -> this.getTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_TASK_COMPLETED_KEY)));
            fields.add(new StatField(StatsCatalog.STAT_LATEST_TASK_ASSIGNED, () -> this.getTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_TASK_ASSIGNED_KEY)));
            fields.add(new StatField(StatsCatalog.STAT_LATEST_APPROVAL_WITH_CREDENTIALS, () -> this.getTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_APPROVAL_WITH_CREDENTIALS_KEY)));
            fields.add(new StatField(StatsCatalog.STAT_LATEST_WORKFLOW_LINKED_TO_SPACE_CATEGORY, () -> this.getTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_WORKFLOW_LINKED_TO_SPACE_CATEGORY_KEY)));
            fields.add(new StatField(StatsCatalog.STAT_GET_METADATA_MACRO_TOTAL, () -> this.countPagesWithMacro("get-metadata")));
            fields.addAll(this.workflowStatsGather.getMarkUpAnalyticsFields());
        }
        fields.addAll(this.readAckInformationGatherer.getAnalyticsFields());
        fields.addAll(this.eSignatureStatsGatherer.getAnalyticsFields());
        fields.addAll(this.upgradeStatsGatherer.getAnalyticsFields());
        fields.add(new StatField(StatsCatalog.STAT_LATEST_APPROVED_OR_REJECTED, () -> this.getTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_APPROVED_OR_REJECTED_KEY)));
        fields.add(new StatField(StatsCatalog.STAT_LATEST_PAGE_WORKFLOW_SAVED, () -> this.getTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_PAGE_WORKFLOW_SAVED_KEY)));
        fields.add(new StatField(StatsCatalog.STAT_LATEST_APPROVAL_ASSIGNED, () -> this.getTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_APPROVAL_ASSIGNED_KEY)));
        fields.add(new StatField(StatsCatalog.STAT_LATEST_SPACE_WORKFLOW_SAVED, () -> this.getTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_SPACE_WORKFLOW_SAVED_KEY)));
        fields.add(new StatField(StatsCatalog.STAT_LATEST_STATE_SELECTED, () -> this.getTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_STATE_SELECTED_KEY)));
        return (StatField[])ArrayUtils.addAll((Object[])super.getExtendedStatFields(), (Object[])fields.toArray(new StatField[0]));
    }

    protected long getActivePages() {
        return this.approvalsSearchService.getNumberOfPagesWithWorkflow();
    }

    protected long getTotalPages() {
        long count = 0L;
        List spaces = this.spaceManager.getAllSpaces();
        for (Space space : spaces) {
            long pages = this.spaceManager.findPageTotal(space);
            count += pages;
        }
        return count;
    }

    protected long getActiveSpaces() {
        return this.approvalsSearchService.getNumberOfSpacesWithWorkflow();
    }

    protected long getTotalSpaces() {
        List spaces = this.spaceManager.getAllSpaces();
        return spaces.size();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

