/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.readack.ReadAckException;
import com.comalatech.confluence.readack.model.ReadAckConfig;
import com.comalatech.confluence.readack.service.ReadAckConfigManager;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.PageSectionsManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.workflow.WorkflowHandler;
import com.comalatech.workflow.model.PageStatus;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class WorkflowSettingsWebPanel
implements WebPanel,
ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(WorkflowSettingsWebPanel.class);
    public static final String SPACE_WORKFLOW_ALLOWED = "cwSpaceWorkflowAllowed";
    public static final String WORKFLOWS_APP_AVAILABILITY = "isWorkflowsApp";
    public static final String APPROVALS_APP_AVAILABILITY = "isApprovalsApp";
    public static final String WORKFLOWS_LITE_APP_AVAILABILITY = "isWorkflowsLiteApp";
    public static final String IS_COMALA_APP_LICENSED = "isComalaAppLicensed";
    public static final String PLUGIN_KEY = "pluginKey";
    public static final String PAGE_HAS_WORKFLOW = "hasWorkflow";
    public static final String PAGE_HAS_READ_ACK = "hasReadAck";
    public static final String IS_PAGE_READ_ACK = "isPageReadAck";
    public static final String WORKFLOW_VERSION = "workflowVersion";
    public static final String CW_SPACE_ADMIN = "cwIsSpaceAdmin";
    public static final String CW_CONFLUENCE_ADMIN_GROUP = "cwIsConfluenceAdmin";
    public static final String CW_CONFLUENCE_DATE_FORMAT = "cwConfluenceDateFormat";
    public static final String CW_CONFLUENCE_TIME_FORMAT = "cwConfluenceTimeFormat";
    public static final String CW_CONFLUENCE_DATETIME_FORMAT = "cwConfluenceDateTimeFormat";
    public static final String CW_CONFLUENCE_LOCALE = "cwConfluenceLocale";
    public static final String CW_SHOW_WORKFLOW_TRANSLATOR = "cwShowWorkflowTranslator";
    private ApplicationContext applicationContext;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final WorkflowHandler workflowHandler;
    private final PageSectionsManager pageSectionsManager;
    private final WorkflowAccessor workflowAccessor;
    private final WorkflowPermissionManager workflowPermissionManager;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final PluginLicenseManager pluginLicenseManager;
    private ReadAckConfigManager readAckConfigManager;
    private final FormatSettingsManager formatSettingsManager;
    private final LocaleManager localeManager;
    private final ComalaI18nBean comalaI18nBean;
    private final VelocityHelperService velocityHelperService;

    public WorkflowSettingsWebPanel(WorkflowConfigurationManager workflowConfigurationManager, WorkflowHandler workflowHandler, PageSectionsManager pageSectionsManager, WorkflowAccessor workflowAccessor, WorkflowPermissionManager workflowPermissionManager, WorkflowsFeatureManager workflowsFeatureManager, PluginLicenseManager pluginLicenseManager, FormatSettingsManager formatSettingsManager, LocaleManager localeManager, ComalaI18nBean comalaI18nBean, VelocityHelperService velocityHelperService) {
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.workflowHandler = workflowHandler;
        this.pageSectionsManager = pageSectionsManager;
        this.workflowAccessor = workflowAccessor;
        this.workflowPermissionManager = workflowPermissionManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
        this.comalaI18nBean = comalaI18nBean;
        this.velocityHelperService = velocityHelperService;
    }

    public void afterPropertiesSet() throws Exception {
        this.readAckConfigManager = (ReadAckConfigManager)this.applicationContext.getBean(ReadAckConfigManager.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getHtml(Map<String, Object> context) {
        StringBuilder html = new StringBuilder();
        HashMap<String, String> fields = new HashMap<String, String>();
        ConfluenceActionSupport action = (ConfluenceActionSupport)context.get("action");
        if (action == null) {
            return html.toString();
        }
        WebInterfaceContext webInterfaceContext = action.getWebInterfaceContext();
        Space space = webInterfaceContext.getSpace();
        AbstractPage page = webInterfaceContext.getPage();
        if (page != null) {
            PageWorkflows pageWorkflows;
            fields.put("approvalsLabel", this.comalaI18nBean.getText("approvalsworkflow.approvals.name"));
            fields.put("statesLabel", this.comalaI18nBean.getText("approvalsworkflow.state.name"));
            fields.put("parametersLabel", this.comalaI18nBean.getText("comalatech.awp.parameters.parameters.name"));
            fields.put("tasksLabel", this.comalaI18nBean.getText("adhoctasks.tasks.label"));
            boolean published = webInterfaceContext.getParameter("releasedMode") != null;
            PageStatus pageStatus = this.workflowHandler.getPageStatus((ContentEntityObject)page, published, false);
            if (pageStatus != null) {
                html.append("<div id='workflow-page-status' style='display: none;'>").append(pageStatus.toAjsParams()).append("</div>\n");
            }
            if ((pageWorkflows = this.workflowAccessor.getPageWorkflows(page.getLatestVersion())) != null && (!pageWorkflows.isRequiresFinalApproval() || published || this.workflowPermissionManager.canViewDrafts(page, AuthenticatedUserThreadLocal.get()))) {
                PageSectionsManager.PageSections pageSections = this.pageSectionsManager.renderPageSections(pageWorkflows, null, published);
                html.append("<div style='display: none;'>");
                html.append(pageSections.getHeader());
                html.append(pageSections.getFooter());
                html.append(pageSections.getTrialMessage());
                html.append("</div>");
            }
            fields.put(PAGE_HAS_WORKFLOW, Boolean.toString(this.workflowAccessor.hasWorkflowsOrApprovals((ContentEntityObject)page)));
            try {
                ReadAckConfig config = this.readAckConfigManager.loadReadAckConfig(page, true);
                fields.put(PAGE_HAS_READ_ACK, Boolean.toString(config != null && pageStatus != null && (pageStatus.isFinalState() || pageStatus.isPublishedView() || pageStatus.getStateName() == null)));
                fields.put(IS_PAGE_READ_ACK, Boolean.toString(config != null && pageWorkflows != null && pageWorkflows.isPageReadConfirmation()));
            }
            catch (ReadAckException e) {
                log.error("Couldn't retrieve Read Ack config from the page", (Throwable)e);
            }
        }
        if (space != null) {
            fields.put(SPACE_WORKFLOW_ALLOWED, Boolean.valueOf(this.workflowConfigurationManager.getConfiguration().isSpaceWorkflowsAllowed(space.getKey())).toString());
            fields.put(WORKFLOW_VERSION, this.workflowConfigurationManager.getWorkflowVersionNumber());
        }
        fields.put(WORKFLOWS_APP_AVAILABILITY, Boolean.toString(this.workflowsFeatureManager.isWorkflowsApp()));
        fields.put(APPROVALS_APP_AVAILABILITY, Boolean.toString(this.workflowsFeatureManager.isApprovalsApp()));
        fields.put(WORKFLOWS_LITE_APP_AVAILABILITY, Boolean.toString(this.workflowsFeatureManager.isWorkflowsLiteApp()));
        Option pluginLicense = this.pluginLicenseManager.getLicense();
        fields.put(IS_COMALA_APP_LICENSED, pluginLicense.isDefined() ? Boolean.toString(((PluginLicense)pluginLicense.get()).isValid()) : "false");
        fields.put(PLUGIN_KEY, this.pluginLicenseManager.getPluginKey());
        fields.put(CW_SPACE_ADMIN, Boolean.toString(this.workflowPermissionManager.canAdministerSpace(space, AuthenticatedUserThreadLocal.get())));
        fields.put(CW_CONFLUENCE_ADMIN_GROUP, Boolean.toString(this.workflowPermissionManager.canAdministerConfluence(AuthenticatedUserThreadLocal.get())));
        fields.put(CW_CONFLUENCE_DATE_FORMAT, this.formatSettingsManager.getDateFormat());
        fields.put(CW_CONFLUENCE_TIME_FORMAT, this.formatSettingsManager.getTimeFormat());
        fields.put(CW_CONFLUENCE_DATETIME_FORMAT, this.formatSettingsManager.getDateTimeFormat());
        fields.put(CW_CONFLUENCE_LOCALE, TimerUtils.getLocale(this.localeManager).getLanguage());
        fields.put(CW_SHOW_WORKFLOW_TRANSLATOR, Boolean.toString(this.workflowConfigurationManager.isWorkflowTranslatorEnabled()));
        if (fields.size() > 0) {
            html.append("<fieldset class=\"parameters hidden\">\n");
            for (String fieldName : fields.keySet()) {
                html.append("<input type=\"hidden\" id=\"").append(fieldName).append("\" value=\"").append((String)fields.get(fieldName)).append("\"/>\n");
            }
            html.append("</fieldset>");
        }
        html.append(this.uiXTemplates());
        return html.toString();
    }

    public String uiXTemplates() {
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("workflowConfigurationManager", this.workflowConfigurationManager);
        try {
            return this.velocityHelperService.getRenderedTemplateWithoutSwallowingErrors("templates/adhocworkflows/vm/adhocworkflows.vm", contextMap);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "";
        }
    }

    public void writeHtml(Writer writer, Map<String, Object> stringObjectMap) throws IOException {
    }
}

