/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.tasks.extractor;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.dataextractor.model.UserKeyListContentProperty;
import com.comalatech.confluence.dataextractor.model.version.TaskContentPropertyModelVersion;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.extractor.model.CompletedTasksContentProperty;
import com.comalatech.confluence.tasks.extractor.model.PageTasksContentPropertyModel;
import com.comalatech.confluence.tasks.extractor.model.PendingTasksContentProperty;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.workflow.StateService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskPropertyExtractor {
    private static final Logger log = LoggerFactory.getLogger(TaskPropertyExtractor.class);
    private final StateService stateService;
    private final UserAccessor userAccessor;
    private final ObjectMapper mapper;

    public TaskPropertyExtractor(StateService stateService, @ComponentImport UserAccessor userAccessor) {
        this.stateService = stateService;
        this.userAccessor = userAccessor;
        this.mapper = new ObjectMapper();
        this.mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }

    public String getJsonOf(AbstractPage page) {
        PageTasksContentPropertyModel data = this.extractFrom(page);
        return this.serialize(data);
    }

    private PageTasksContentPropertyModel extractFrom(AbstractPage page) {
        PageState currentState = (PageState)this.stateService.getCurrentState((ContentEntityObject)page);
        List<PendingTasksContentProperty> pendingTasksContentProperties = this.extractPendingTasks(currentState);
        List<CompletedTasksContentProperty> completedTasksContentProperties = this.extractCompletedTasks(currentState);
        Set<String> userId = this.extractPendingTaskUsers(pendingTasksContentProperties);
        PageTasksContentPropertyModel pageTasks = new PageTasksContentPropertyModel();
        pageTasks.setPendingTasksContentProperties(pendingTasksContentProperties);
        pageTasks.setUserKeyListContentProperty(UserKeyListContentProperty.fromKeys(userId));
        pageTasks.setCompletedTasksContentProperties(completedTasksContentProperties);
        return pageTasks;
    }

    private List<CompletedTasksContentProperty> extractCompletedTasks(PageState pageState) {
        if (Objects.isNull(pageState) || Objects.isNull(pageState.getPageTasks().getCompletedTasks())) {
            return Collections.emptyList();
        }
        List<PageTask> tasks = pageState.getPageTasks().getCompletedTasks();
        return tasks.stream().map(CompletedTasksContentProperty::fromTask).collect(Collectors.toList());
    }

    public <T> String serialize(T data) {
        try {
            return this.mapper.writeValueAsString(data);
        }
        catch (Exception e) {
            String className = data == null ? "" : data.getClass().getSimpleName();
            log.error("{} could not be serialized", (Object)className, (Object)e);
            return "";
        }
    }

    public String getCurrentTaskModelVersionJson() {
        return this.serialize(TaskContentPropertyModelVersion.getCurrentVersion());
    }

    private List<PendingTasksContentProperty> extractPendingTasks(PageState pState) {
        if (Objects.isNull(pState) || Objects.isNull(pState.getTasks())) {
            return Collections.emptyList();
        }
        return pState.getTasks().stream().map(PendingTasksContentProperty::fromTask).collect(Collectors.toList());
    }

    private Set<String> extractPendingTaskUsers(List<PendingTasksContentProperty> pendingTasks) {
        if (Objects.isNull(pendingTasks)) {
            return Collections.emptySet();
        }
        return pendingTasks.stream().map(currentPendingTask -> this.userAccessor.getUserByName(currentPendingTask.getAssignedTo())).filter(Objects::nonNull).map(pendingTaskUser -> pendingTaskUser.getKey().toString()).collect(Collectors.toSet());
    }
}

