/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.tasks;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.StateManager;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.PageTaskManager;
import com.comalatech.confluence.tasks.event.blogpost.AllBlogPostTasksCompleteEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskAssignEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskCompleteEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskDueDateCreatedEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskDueDateDeletedEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskDueDateUpdatedEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskUnassignEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskUpdatedEvent;
import com.comalatech.confluence.tasks.event.page.AllPageTasksCompleteEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskAssignEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskCompleteEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskDueDateCreatedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskDueDateDeletedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskDueDateUpdatedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskUnassignEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskUpdatedEvent;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.tasks.model.PageTasks;
import com.comalatech.confluence.tasks.model.TaskType;
import com.comalatech.confluence.workflow.WorkflowException;
import org.springframework.stereotype.Component;

@Component
public class DefaultPageTaskManager
implements PageTaskManager {
    public static final String TASKS_KEY = "com.comalatech.awp.tasks";
    private final StateManager stateManager;
    private final StateAccessor stateAccessor;
    private final PermissionManager permissionManager;
    private final EventPublisher eventPublisher;

    public DefaultPageTaskManager(StateManager stateManager, StateAccessor stateAccessor, @ComponentImport PermissionManager permissionManager, @ComponentImport EventPublisher eventPublisher) {
        this.stateManager = stateManager;
        this.stateAccessor = stateAccessor;
        this.permissionManager = permissionManager;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public PageTasks getPageTasks(AbstractPage page, boolean determineTaskAvailability, boolean strictTasks, boolean workflowAdminUser) {
        PageState state = this.stateAccessor.getLatestState(page);
        if (state == null) {
            return null;
        }
        PageTasks tasks = state.getPageTasks();
        if (determineTaskAvailability) {
            this.determineTaskAvailability(page, tasks, strictTasks, workflowAdminUser);
        }
        return tasks;
    }

    @Override
    public void determineTaskAvailability(AbstractPage page, PageTasks tasks, boolean strictTasks, boolean workflowAdminUser) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        boolean canEdit = this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)page);
        for (PageTask task : tasks.get()) {
            task.setCanComplete(workflowAdminUser || this.canComplete(task, user, canEdit, strictTasks));
        }
    }

    @Override
    public boolean canComplete(PageTask task, ConfluenceUser user, boolean canViewWorkflow, boolean strictTasks) {
        if (user == null) {
            return false;
        }
        if (!canViewWorkflow) {
            return false;
        }
        Assignment assignment = task.getCurrentAssignment();
        if (assignment == null || !strictTasks) {
            return true;
        }
        if (task.getPerformer().equals(user.getName())) {
            return true;
        }
        if (assignment.getPerformer().equals(user.getName())) {
            return true;
        }
        return assignment.getAssignee() != null && assignment.getAssignee().equals(user.getName());
    }

    @Override
    public void addPageTask(AbstractPage page, PageState state, PageTask task) {
        this.stateManager.addTask(page, task);
    }

    @Override
    public void updateTask(AbstractPage page, PageState state, PageTask task, PageTask oldTask, String performer) {
        this.stateManager.updateTask(page, task);
        if (page instanceof Page) {
            if (this.hasTaskDescriptionOrNameUpdated(task, oldTask)) {
                this.eventPublisher.publish((Object)new PageTaskUpdatedEvent(this, (Page)page, state, task, oldTask, performer));
            }
            if (this.hasTaskDueDateCreated(task, oldTask)) {
                this.eventPublisher.publish((Object)new PageTaskDueDateCreatedEvent(this, (Page)page, state, task, oldTask));
            }
            if (this.hasTaskDueDateUpdated(task, oldTask)) {
                this.eventPublisher.publish((Object)new PageTaskDueDateUpdatedEvent(this, (Page)page, state, task, oldTask));
            }
            if (this.hasTaskDueDateRemoved(task, oldTask)) {
                this.eventPublisher.publish((Object)new PageTaskDueDateDeletedEvent(this, (Page)page, state, task, oldTask));
            }
        } else {
            if (this.hasTaskDescriptionOrNameUpdated(task, oldTask)) {
                this.eventPublisher.publish((Object)new BlogPostTaskUpdatedEvent(this, (BlogPost)page, state, task, oldTask, performer));
            }
            if (this.hasTaskDueDateCreated(task, oldTask)) {
                this.eventPublisher.publish((Object)new BlogPostTaskDueDateCreatedEvent(this, (BlogPost)page, state, task, oldTask));
            }
            if (this.hasTaskDueDateUpdated(task, oldTask)) {
                this.eventPublisher.publish((Object)new BlogPostTaskDueDateUpdatedEvent(this, (BlogPost)page, state, task, oldTask));
            }
            if (this.hasTaskDueDateRemoved(task, oldTask)) {
                this.eventPublisher.publish((Object)new BlogPostTaskDueDateDeletedEvent(this, (BlogPost)page, state, task, oldTask));
            }
        }
    }

    @Override
    public void removeTask(AbstractPage page, PageTask task, String deletionComment) {
        this.stateManager.removeTask(page, task, deletionComment);
    }

    @Override
    public void assignTask(AbstractPage page, PageState state, PageTask task, Assignment assignment) {
        this.stateManager.updateTask(page, task);
        if (page instanceof Page) {
            if (assignment.getAssignee() == null) {
                this.eventPublisher.publish((Object)new PageTaskUnassignEvent(this, (Page)page, state, task, assignment));
            } else {
                this.eventPublisher.publish((Object)new PageTaskAssignEvent((Object)this, (Page)page, state, task, assignment, false));
            }
        } else if (assignment.getAssignee() == null) {
            this.eventPublisher.publish((Object)new BlogPostTaskUnassignEvent(this, (BlogPost)page, state, task, assignment));
        } else {
            this.eventPublisher.publish((Object)new BlogPostTaskAssignEvent((Object)this, (BlogPost)page, state, task, assignment, false));
        }
    }

    @Override
    public void completeTask(AbstractPage page, ConfluenceUser user, PageState state, PageTask task, TaskCompletion completion) throws WorkflowException {
        task.complete(completion);
        if (task.getType() == TaskType.QUESTION) {
            this.reassignQuestion(page, state, task, completion);
        }
        this.stateManager.updateTask(page, task);
        if (page instanceof Page) {
            this.eventPublisher.publish((Object)new PageTaskCompleteEvent(this, (Page)page, state, task, completion));
        } else {
            this.eventPublisher.publish((Object)new BlogPostTaskCompleteEvent(this, (BlogPost)page, state, task, completion));
        }
        PageState currentState = this.stateAccessor.getLatestState(page);
        if (state.getId() == currentState.getId() && currentState.getPageTasks().isCompleted()) {
            if (page instanceof Page) {
                this.eventPublisher.publish((Object)new AllPageTasksCompleteEvent(this, (Page)page, currentState));
            } else {
                this.eventPublisher.publish((Object)new AllBlogPostTasksCompleteEvent(this, (BlogPost)page, currentState));
            }
        }
    }

    private void reassignQuestion(AbstractPage page, PageState state, PageTask task, TaskCompletion completion) {
        if (task.getPerformer() == null || completion.getPerformer() == null || task.getPerformer().equals(completion.getPerformer())) {
            return;
        }
        Assignment assignment = new Assignment(completion.getPerformer(), completion.getDate(), task.getPerformer(), null, null, null);
        assignment.setComment(completion.getComment());
        this.assignTask(page, state, task, assignment);
    }

    private boolean hasTaskDescriptionOrNameUpdated(PageTask task, PageTask oldTask) {
        if (task != null && oldTask != null) {
            if (task.getName() != null && oldTask.getName() != null && !task.getName().equals(oldTask.getName())) {
                return true;
            }
            if (task.getComment() != null && task.getComment().isEmpty() && oldTask.getComment() == null) {
                return false;
            }
            return task.getComment() != null && !task.getComment().equals(oldTask.getComment());
        }
        return false;
    }

    private boolean hasTaskDueDateRemoved(PageTask task, PageTask oldTask) {
        if (task != null && oldTask != null) {
            return oldTask.getDueDate() != null && task.getDueDate() == null;
        }
        return false;
    }

    private boolean hasTaskDueDateUpdated(PageTask task, PageTask oldTask) {
        if (task != null && oldTask != null) {
            return oldTask.getDueDate() != null && task.getDueDate() != null && !oldTask.getDueDate().equals(task.getDueDate());
        }
        return false;
    }

    private boolean hasTaskDueDateCreated(PageTask task, PageTask oldTask) {
        if (task != null && oldTask != null) {
            return oldTask.getDueDate() == null && task.getDueDate() != null;
        }
        return false;
    }

    private class TasksContainer {
        long pageId;
        PageTasks tasks;

        private TasksContainer(long pageId, PageTasks tasks) {
            this.pageId = pageId;
            this.tasks = tasks;
        }
    }
}

