/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.resources;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhocworkflows.rest.permissions.EditPagePermissionRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.ViewPagePermissionRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.ViewWorkflowPermissionRequired;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.readack.ReadAckException;
import com.comalatech.confluence.readack.model.ReadAckConfig;
import com.comalatech.confluence.readack.model.ReadAckPageStatus;
import com.comalatech.confluence.readack.resources.AbstractRestReadAckResource;
import com.comalatech.confluence.readack.service.ReadAckConfigManager;
import com.comalatech.confluence.readack.service.ReadAckManager;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.analytics.ReadAckInformationGatherer;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.restv2.model.mappers.MapperException;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.WorkflowException;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.Clock;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/readack")
public class ReadAckResource
extends AbstractRestReadAckResource {
    private static final Logger log = LoggerFactory.getLogger(ReadAckResource.class);
    private final AdhocWorkflowManager adhocWorkflowManager;
    private final ReadAckConfigManager readAckConfigManager;
    private final ReadAckManager readAckManager;
    private final ReadAckInformationGatherer readAckInformationGatherer;
    private final WorkflowContainerManager workflowContainerManager;
    private final WorkflowAccessor workflowAccessor;

    public ReadAckResource(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PageManager pageManager, WorkflowMarkupManager workflowMarkupManager, WorkflowsFeatureManager workflowsFeatureManager, ReadAckManager readAckManager, WorkflowPermissionManager workflowPermissionManager, AdhocWorkflowManager adhocWorkflowManager, ReadAckConfigManager readAckConfigManager, ReadAckInformationGatherer readAckInformationGatherer, WorkflowContainerManager workflowContainerManager, WorkflowAccessor workflowAccessor, ComalaI18nBean comalaI18nBean) {
        super(permissionManager, spaceManager, pageManager, workflowMarkupManager, workflowsFeatureManager, workflowPermissionManager, comalaI18nBean);
        this.readAckManager = readAckManager;
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.readAckConfigManager = readAckConfigManager;
        this.readAckInformationGatherer = readAckInformationGatherer;
        this.workflowContainerManager = workflowContainerManager;
        this.workflowAccessor = workflowAccessor;
    }

    @GET
    @ViewPagePermissionRequired
    @Path(value="/{pageId}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Response getReadAckStatus(@PathParam(value="pageId") Long pageId, final @QueryParam(value="expand") String expandStr) {
        return new AbstractRestReadAckResource.RestReadAckCommand(pageId){

            @Override
            public Response doExecute() throws ReadAckException {
                boolean expand = StringUtils.isNotBlank((CharSequence)expandStr) && expandStr.equalsIgnoreCase("true");
                try {
                    ReadAckPageStatus readAckStatus = ReadAckResource.this.readAckManager.getPageStatus(this.page, this.canViewWorkflows, expand);
                    if (readAckStatus == null) {
                        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                    }
                    return Response.ok().entity((Object)readAckStatus).type("application/json").build();
                }
                catch (ReadAckException e) {
                    log.error("Can't get ReadAck status for page " + this.page.getTitle(), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
        }.execute();
    }

    @PUT
    @ViewPagePermissionRequired
    @Path(value="/{pageId}")
    @Produces(value={"application/json"})
    public Response acknowledge(final @PathParam(value="pageId") Long pageId) {
        return new AbstractRestReadAckResource.RestReadAckCommand(pageId){

            @Override
            public Response doExecute() {
                try {
                    ReadAckPageStatus readAckStatus = ReadAckResource.this.readAckManager.acknowledge(this.page, this.canViewWorkflows);
                    if (readAckStatus == null) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                    }
                    return Response.ok().entity((Object)readAckStatus).type("application/json").build();
                }
                catch (ReadAckException e) {
                    log.error("There was an error when acknowledging the read of page " + pageId, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
        }.execute();
    }

    @POST
    @EditPagePermissionRequired
    @ReadOnlyAccessBlocked
    @Path(value="/{pageId}/readers/update")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateReadAckReaders(@PathParam(value="pageId") Long pageId, final Map<UserUpdateCommand, List<String>> users) {
        return new AbstractRestReadAckResource.RestReadAckCommand(pageId){

            @Override
            public Response doExecute() {
                try {
                    ReadAckPageStatus readAckPageStatus = ReadAckResource.this.readAckManager.updateReadAckReaders(this.page, users, this.canViewWorkflows);
                    ReadAckResource.this.readAckInformationGatherer.setReadAckTimeStampStat(Clock.systemDefaultZone(), "latestReadersModified");
                    return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)readAckPageStatus).type("application/json").build();
                }
                catch (ReadAckException e) {
                    log.error("There was an error when updating users, parameter {}", (Object)users, (Object)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
            }
        }.execute();
    }

    @PUT
    @EditPagePermissionRequired
    @ReadOnlyAccessBlocked
    @Path(value="/{pageId}/duedate/update")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setOrUpdateReadAckDueDate(@PathParam(value="pageId") Long pageId, final LinkedHashMap dueDateMap) {
        return new AbstractRestReadAckResource.RestReadAckCommand(pageId){

            @Override
            public Response doExecute() {
                try {
                    String dueDateStr = dueDateMap.get("dueDate") != null ? dueDateMap.get("dueDate").toString() : null;
                    DateTime now = DateTime.now();
                    Long dueDate = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dueDateStr}) ? Long.valueOf(now.plus(TimerUtils.parsePeriod(dueDateStr)).getMillis()) : null;
                    ReadAckPageStatus readAckPageStatus = ReadAckResource.this.readAckManager.createOrUpdateReadAckDueDate(this.page, dueDate, this.canViewWorkflows);
                    return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)readAckPageStatus).type("application/json").build();
                }
                catch (ReadAckException e) {
                    log.error("There was an error when updating dueDate {}", (Object)dueDateMap.get("dueDate").toString(), (Object)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
            }
        }.execute();
    }

    @POST
    @EditPagePermissionRequired
    @ReadOnlyAccessBlocked
    @Path(value="/{pageId}/readers/request")
    @Produces(value={"application/json"})
    public Response reset(final @PathParam(value="pageId") Long pageId) {
        return new AbstractRestReadAckResource.RestReadAckCommand(pageId){

            @Override
            public Response doExecute() {
                try {
                    ReadAckPageStatus readAckPageStatus = ReadAckResource.this.readAckManager.resetReadConfirmation(this.page);
                    if (readAckPageStatus == null) {
                        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                    }
                    return Response.ok().entity((Object)readAckPageStatus).type("application/json").build();
                }
                catch (ReadAckException e) {
                    log.error("There was an error resetting the read confirmation in the page {}", (Object)pageId, (Object)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
        }.execute();
    }

    @POST
    @Path(value="/pageReadAck/{pageId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessBlocked
    @EditPagePermissionRequired
    public Response createPageReadAck(final @PathParam(value="pageId") Long contentId) {
        return new AbstractRestReadAckResource.RestReadAckCommand(contentId){

            @Override
            public Response doExecute() {
                try {
                    AbstractPage page = ReadAckResource.this.pageManager.getAbstractPage(contentId.longValue());
                    if (page == null) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                    }
                    Workflow workflow = ReadAckResource.this.adhocWorkflowManager.parseWorkflowMarkup("{workflow:name=Simple Read Confirmation | isPageReadConfirmation=true}{read-ack}{workflow}");
                    if (!ReadAckResource.this.adhocWorkflowManager.hasWorkflow(page) && !ReadAckResource.this.workflowContainerManager.hasProductionWorkflows(page)) {
                        ReadAckResource.this.adhocWorkflowManager.savePageWorkflow(page, workflow, false);
                        ReadAckResource.this.readAckConfigManager.loadReadAckConfig(page, true);
                        ReadAckPageStatus readAckStatus = ReadAckResource.this.readAckManager.getPageStatus(page, this.canViewWorkflows, false);
                        if (readAckStatus == null) {
                            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                        }
                        return Response.ok().entity((Object)readAckStatus).type("application/json").build();
                    }
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"There is a already a page workflow in the current page").build();
                }
                catch (WorkflowException ex) {
                    log.error("Error creating/read confirmation page", (Throwable)ex);
                    return Response.serverError().build();
                }
                catch (MapperException mEx) {
                    log.error("Mapper error trying to restify a read confirmation", (Throwable)mEx);
                    return Response.serverError().build();
                }
            }
        }.execute();
    }

    @ReadOnlyAccessBlocked
    @EditPagePermissionRequired
    @DELETE
    @Path(value="/pageReadAck/{pageId}/")
    public Response removePageReadAck(final @PathParam(value="pageId") Long contentId) {
        return new AbstractRestReadAckResource.RestReadAckCommand(contentId){

            @Override
            public Response doExecute() {
                try {
                    AbstractPage page = ReadAckResource.this.pageManager.getAbstractPage(contentId.longValue());
                    if (page == null) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                    }
                    Workflow workflow = ReadAckResource.this.adhocWorkflowManager.getPageWorkflow(page);
                    if (workflow != null && workflow.isPageReadConfirmation()) {
                        ReadAckResource.this.adhocWorkflowManager.removeWorkflow(page);
                        ReadAckConfig readAckConfig = ReadAckResource.this.readAckConfigManager.loadReadAckConfig(page, false);
                        ReadAckResource.this.readAckManager.closePendingReadAcks(readAckConfig);
                        ReadAckResource.this.readAckConfigManager.removeReadAckConfig(page);
                        return Response.ok((Object)Response.Status.OK).build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"There is not a page read confirmation workflow in the current page").build();
                }
                catch (WorkflowException ex) {
                    log.error("Error deleting/read confirmation page", (Throwable)ex);
                    return Response.serverError().build();
                }
                catch (MapperException mEx) {
                    log.error("Mapper error trying to restify a read confirmation", (Throwable)mEx);
                    return Response.serverError().build();
                }
            }
        }.execute();
    }

    @PUT
    @ViewWorkflowPermissionRequired
    @Path(value="/suppress/{pageId}")
    @ApiResponses(value={@ApiResponse(code=201, message="Suppress Read Confirmation value for the current page is created."), @ApiResponse(code=204, message="Suppress Read Confirmation value for the current page is updated"), @ApiResponse(code=403, message="Cannot change suppress value, read confirmation markup does not allow it"), @ApiResponse(code=304, message="Enabled value is the same as the one already stored.")})
    public Response suppressReadConfirmation(final @PathParam(value="pageId") Long pageId, final @QueryParam(value="enabled") String enabled) {
        return new AbstractRestReadAckResource.RestReadAckCommand(pageId){
            Response responseStatus;
            final AbstractPage page;
            final PageWorkflows pageWorkflows;
            final boolean suppressReadAck;
            {
                super(ReadAckResource.this, contentId);
                this.responseStatus = null;
                this.page = ReadAckResource.this.pageManager.getAbstractPage(pageId.longValue());
                this.pageWorkflows = ReadAckResource.this.workflowAccessor.getPageWorkflows(this.page);
                this.suppressReadAck = BooleanUtils.toBoolean((String)enabled);
            }

            @Override
            public Response doExecute() {
                try {
                    if (!this.pageWorkflows.getReadAck().getApproverRequestOption()) {
                        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                    }
                    Boolean suppressReadAckPreviousValue = ReadAckResource.this.readAckConfigManager.getSuppressNotificationValue(this.page);
                    if (!Objects.equals(this.suppressReadAck, suppressReadAckPreviousValue)) {
                        ReadAckResource.this.readAckConfigManager.setSuppressNotificationValue(this.page, this.suppressReadAck);
                        this.responseStatus = suppressReadAckPreviousValue == null ? Response.status((Response.Status)Response.Status.CREATED).build() : Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                    } else {
                        this.responseStatus = Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
                    }
                }
                catch (Exception e) {
                    log.error("There was an error when trying to suppress the read of page {}", (Object)pageId, (Object)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                return this.responseStatus;
            }
        }.execute();
    }

    public static enum UserUpdateCommand {
        REMOVED_USERS("removedUsers"),
        ADDED_USERS("addedUsers");

        private final String value;

        private UserUpdateCommand(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static UserUpdateCommand fromString(String value) {
            for (UserUpdateCommand command : UserUpdateCommand.values()) {
                if (!command.toString().equals(value)) continue;
                return command;
            }
            throw new IllegalArgumentException("invalid string value passed: " + value);
        }
    }
}

