/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.PdfTemplateExportIntegrationServiceAccessor;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.PdfTemplateExportIntegrationServiceFactory;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.PdfTemplateExportIntegrationServiceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DefaultPdfTemplateExportIntegrationServiceAccessor
implements PdfTemplateExportIntegrationServiceAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultPdfTemplateExportIntegrationServiceAccessor.class);
    private final ApplicationContext applicationContext;
    private PdfTemplateExportIntegrationServiceHolder pdfTemplateExportIntegrationServiceHolder;

    public DefaultPdfTemplateExportIntegrationServiceAccessor(@ComponentImport ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private void initPdfTemplateExportIntegrationServiceHolder() {
        try {
            Class<?> pdfTemplateServiceClass = this.getPdfTemplateServiceClass();
            if (pdfTemplateServiceClass != null) {
                this.pdfTemplateExportIntegrationServiceHolder = ((PdfTemplateExportIntegrationServiceFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(pdfTemplateServiceClass, 3, false)).get();
            }
        }
        catch (Exception e) {
            log.error("Could not create pdfTemplateServiceHolder", (Throwable)e);
        }
    }

    private Class<?> getPdfTemplateServiceClass() {
        try {
            this.getClass().getClassLoader().loadClass("com.k15t.scroll.exporter.api.pdf.PdfExportService");
            return this.getClass().getClassLoader().loadClass("com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.PdfTemplateExportIntegrationServiceFactory");
        }
        catch (Exception e) {
            log.info("The necessary supplier class is unavailable.");
            return null;
        }
    }

    @Override
    public PdfTemplateExportIntegrationServiceHolder getPdfTemplateExportIntegrationServiceHolder() {
        if (this.pdfTemplateExportIntegrationServiceHolder == null) {
            this.initPdfTemplateExportIntegrationServiceHolder();
        }
        return this.pdfTemplateExportIntegrationServiceHolder;
    }
}

