/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.rest.validator;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowVisibilityPermissionsRequired;
import com.comalatech.confluence.util.validators.PermissionValidator;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component(value="permissionValidator")
public class DefaultPermissionValidator
implements PermissionValidator {
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final AccessModeService accessModeService;
    private final PermissionManager permissionManager;
    private final PageManager pageManager;
    private final SpaceManager spaceManager;

    public DefaultPermissionValidator(WorkflowConfigurationManager workflowConfigurationManager, @ComponentImport AccessModeService accessModeService, @ComponentImport PermissionManager permissionManager, @ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.accessModeService = accessModeService;
        this.permissionManager = permissionManager;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
    }

    @Override
    public void validate(Collection<Annotation> annotations, Long pageId) throws ApplicationPermissionException {
        this.validateWorkflowVisibilityPermission(annotations, Collections.singletonList(pageId));
    }

    @Override
    public void validate(Collection<Annotation> annotations) throws ApplicationPermissionException {
        this.validate(annotations, null);
    }

    @Override
    public void validatePages(Collection<Annotation> annotations, List<Long> pageIds) throws ApplicationPermissionException {
        this.validateWorkflowVisibilityPermission(annotations, pageIds);
    }

    @Override
    public void validateSpaces(Collection<Annotation> annotations, List<String> spaceKeys) throws ApplicationPermissionException {
        this.validateSpaceAdminPermission(annotations, spaceKeys);
    }

    private void validateWorkflowVisibilityPermission(Collection<Annotation> annotations, List<Long> pageIds) throws ApplicationPermissionException {
        if (annotations.stream().noneMatch(a -> a.annotationType().equals(WorkflowVisibilityPermissionsRequired.class))) {
            return;
        }
        if (pageIds == null) {
            throw new ApplicationPermissionException("Forbidden: invalid page. Cannot perform validation.");
        }
        List ids = pageIds.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (ids.isEmpty()) {
            throw new ApplicationPermissionException("Forbidden: invalid page. Cannot perform validation.");
        }
        for (Long pageId : ids) {
            ConfluenceUser user;
            AbstractPage target = null;
            if (pageId != null) {
                target = this.pageManager.getAbstractPage(pageId.longValue());
            }
            if ((user = AuthenticatedUserThreadLocal.get()) == null || target == null) {
                throw new ApplicationPermissionException("Forbidden: No user or invalid page " + pageId + " has been specified. Cannot perform validation.");
            }
            if (this.hasEditPermissionOverrideSettingEnabled(target.getSpaceKey()) || this.canEdit(user, target)) continue;
            throw new ApplicationPermissionException("Forbidden: The user has no edit permission on the page " + pageId + " and the Workflows visibility configuration setting does not allow to override that restriction.");
        }
    }

    private void validateSpaceAdminPermission(Collection<Annotation> annotations, List<String> spaceKeys) throws ApplicationPermissionException {
        if (annotations.stream().noneMatch(a -> a.annotationType().equals(PermissionRequired.class))) {
            return;
        }
        for (String spaceKey : spaceKeys.stream().filter(Objects::nonNull).collect(Collectors.toList())) {
            ConfluenceUser user;
            Space space = null;
            if (spaceKey != null) {
                space = this.spaceManager.getSpace(spaceKey);
            }
            if ((user = AuthenticatedUserThreadLocal.get()) == null || space == null) {
                throw new ApplicationPermissionException("Forbidden: No user or invalid space " + spaceKey + " has been specified. Cannot perform validation.");
            }
            Optional<Annotation> annotation = annotations.stream().filter(a -> a.annotationType().equals(PermissionRequired.class)).findFirst();
            if (this.permissionManager.hasPermission((User)user, Permission.forName((String)((PermissionRequired)annotation.get()).value()[0]), (Object)space)) continue;
            throw new ApplicationPermissionException(user.getName() + " has no admin permission over " + space);
        }
    }

    private boolean hasEditPermissionOverrideSettingEnabled(String spaceKey) {
        return WorkflowVisibilityInternal.ANY.equals((Object)this.workflowConfigurationManager.getHistoryVisibility(spaceKey));
    }

    private boolean canEdit(ConfluenceUser user, AbstractPage target) {
        return (Boolean)this.accessModeService.withReadOnlyAccessExemption(() -> this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)target));
    }
}

