/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.task;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskDeletedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskDeletedEvent;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.workflow.WorkflowUserException;
import org.apache.commons.lang3.StringUtils;

public class TaskDeletionMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public TaskDeletionMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        if (event instanceof PageTaskDeletedEvent) {
            PageTaskDeletedEvent pageTaskDeletedEvent = (PageTaskDeletedEvent)event;
            return this.buildActivity((AbstractPage)pageTaskDeletedEvent.getPage(), (PageState)pageTaskDeletedEvent.getState(), (PageTask)pageTaskDeletedEvent.getTask());
        }
        if (event instanceof BlogPostTaskDeletedEvent) {
            BlogPostTaskDeletedEvent blogPostTaskDeletedEvent = (BlogPostTaskDeletedEvent)event;
            return this.buildActivity((AbstractPage)blogPostTaskDeletedEvent.getBlogPost(), (PageState)blogPostTaskDeletedEvent.getState(), (PageTask)blogPostTaskDeletedEvent.getTask());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, PageTask pageTask) throws WorkflowUserException {
        Actor actor = this.actorUtils.buildActor(pageTask.getDeletion().getPerformer());
        ActionDetails details = new ActionDetails();
        details.addDetail(ActionDetailType.TASK_NAME, pageTask.getName());
        String comment = pageTask.getDeletion().getComment();
        if (!StringUtils.isEmpty((CharSequence)comment)) {
            details.addDetail(ActionDetailType.TASK_COMMENT, comment);
        }
        details.addAll(this.buildStateActionDetails(state));
        Action action = new Action(new ActionType(ActionType.Type.TASK, ActionType.Subtype.TASK_DELETION), actor, details);
        return new Activity(TaskDeletionMapper.buildTarget((ContentEntityObject)abstractPage), pageTask.getDeletion().getDate().getTime(), action);
    }
}

