/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.domain.entities;

import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.domain.entities.adapter.ActionDetailTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class ActionDetail {
    private String value;
    @XmlJavaTypeAdapter(value=ActionDetailTypeAdapter.class)
    private ActionDetailType type;
    private String key;
    private List<Actor> participants;
    public static final List<ActionDetailType> TYPES_WITH_PARTICIPANTS = Arrays.asList(ActionDetailType.APPROVAL_USER_ASSIGNED, ActionDetailType.APPROVAL_USER_UNASSIGNED, ActionDetailType.TASK_USER_ASSIGNED, ActionDetailType.TASK_USER_UNASSIGNED);

    public ActionDetail(String value, ActionDetailType type) {
        this(value, type, null);
    }

    public ActionDetail(String value, ActionDetailType type, String key) {
        this.value = value;
        this.type = type;
        this.key = key;
    }

    public ActionDetail(String value, ActionDetailType type, String key, Actor participant) {
        this(value, type, key);
        this.setParticipant(participant);
    }

    public void setParticipant(Actor participant) {
        if (participant == null) {
            this.participants = null;
        } else {
            this.participants = new ArrayList<Actor>();
            this.participants.add(participant);
        }
    }

    public static boolean isParticipantType(ActionDetailType type) {
        return TYPES_WITH_PARTICIPANTS.contains((Object)type);
    }

    public String getValue() {
        return this.value;
    }

    public ActionDetailType getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public List<Actor> getParticipants() {
        return this.participants;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(ActionDetailType type) {
        this.type = type;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setParticipants(List<Actor> participants) {
        this.participants = participants;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionDetail)) {
            return false;
        }
        ActionDetail other = (ActionDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        ActionDetailType this$type = this.getType();
        ActionDetailType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        List<Actor> this$participants = this.getParticipants();
        List<Actor> other$participants = other.getParticipants();
        return !(this$participants == null ? other$participants != null : !((Object)this$participants).equals(other$participants));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActionDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        ActionDetailType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        List<Actor> $participants = this.getParticipants();
        result = result * 59 + ($participants == null ? 43 : ((Object)$participants).hashCode());
        return result;
    }

    public String toString() {
        return "ActionDetail(value=" + this.getValue() + ", type=" + (Object)((Object)this.getType()) + ", key=" + this.getKey() + ", participants=" + this.getParticipants() + ")";
    }

    public ActionDetail(String value, ActionDetailType type, String key, List<Actor> participants) {
        this.value = value;
        this.type = type;
        this.key = key;
        this.participants = participants;
    }

    public ActionDetail() {
    }
}

