/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.ao.accesor;

import com.comalatech.confluence.documentActivity.ao.ActivityDetailsDeleteCriteria;
import com.comalatech.confluence.documentActivity.ao.accesor.ActivityDetailsRecordAccessor;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityDetailsRecordEntity;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityDetailsRecord;
import com.comalatech.confluence.util.ActiveObjectsAccessor;
import net.java.ao.DBParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ActivityDetailsRecordAccessorImpl
extends ActiveObjectsAccessor
implements ActivityDetailsRecordAccessor {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailsRecordAccessorImpl.class);

    @Override
    public ActivityDetailsRecordEntity create(BaseActivityDetailsRecord record) {
        if (!this.validate(record)) {
            return null;
        }
        ActivityDetailsRecordEntity entity = (ActivityDetailsRecordEntity)this.getAo().create(ActivityDetailsRecordEntity.class, new DBParam[]{new DBParam("ACTIVITY_ID", (Object)record.getActivity().getId()), new DBParam("TYPE", (Object)record.getType()), new DBParam("VALUE", (Object)record.getValue()), new DBParam("KEY", (Object)record.getKey())});
        entity.save();
        if (log.isDebugEnabled()) {
            log.debug("Activity detail record has been created: \n" + record);
        }
        return entity;
    }

    @Override
    public void delete(ActivityDetailsDeleteCriteria criteria) {
        this.getAo().deleteWithSQL(ActivityDetailsRecordEntity.class, this.buildDeleteQuery(criteria), new Object[0]);
    }

    private String buildDeleteQuery(ActivityDetailsDeleteCriteria deleteCriteria) {
        String queryClause = "";
        if (deleteCriteria.getActivityId() != null) {
            queryClause = "ACTIVITY_ID = '" + deleteCriteria.getActivityId() + "' ";
        }
        return queryClause;
    }

    private boolean validate(BaseActivityDetailsRecord record) {
        if (record == null) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)record.getType())) {
            log.warn("Action detail type is null or blank");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)record.getValue())) {
            log.warn("Action detail value is null or empty for type {}", (Object)record.getType());
            return false;
        }
        return true;
    }
}

