/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActions.rest.resources;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.UnrestrictedAccess;
import com.comalatech.confluence.documentActions.presenter.PaginatingAndSortingActionsPresenter;
import com.comalatech.confluence.documentActions.presenter.SingleListActionsPresenter;
import com.comalatech.confluence.documentActions.rest.model.DocumentActionsReport;
import com.comalatech.confluence.documentActions.services.DocumentActionsServiceImpl;
import com.comalatech.confluence.documentActions.services.model.DocumentActionsSearchResult;
import com.comalatech.confluence.documentActions.services.model.search.SearchQuery;
import com.comalatech.confluence.util.cql.CQLExpansionParser;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/report/documentactions")
public class DocumentActionResource {
    private static final Logger log = LoggerFactory.getLogger(DocumentActionResource.class);
    private final CQLSearchService cqlSearchService;
    private final DocumentActionsServiceImpl documentActionsService;

    public DocumentActionResource(@ComponentImport CQLSearchService cqlSearchService, DocumentActionsServiceImpl documentActionsService) {
        this.cqlSearchService = cqlSearchService;
        this.documentActionsService = documentActionsService;
    }

    @Produces(value={"application/json"})
    @UnrestrictedAccess
    @GET
    @ApiResponses(value={@ApiResponse(code=500, message="Exception when trying to retrieve data for Document Actions")})
    public Response search(@QueryParam(value="start") int start, @QueryParam(value="limit") int limit, @QueryParam(value="sortingFields") String sortingFields, @QueryParam(value="sortingOrder") String sortingOrder, @QueryParam(value="type") String type) {
        try {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            if (user != null) {
                SearchQuery searchQuery = this.documentActionsService.buildSearchQuery(start, limit, sortingFields, sortingOrder, type);
                SearchPageResponse searchResults = this.cqlSearchService.search(searchQuery.getCql(), SearchOptions.buildDefault(), (PageRequest)new SimplePageRequest(0, Integer.MAX_VALUE), CQLExpansionParser.parse(searchQuery.getExpand()));
                DocumentActionsSearchResult documentsActionsResult = this.documentActionsService.buildDocumentActionsSearchResultFrom((SearchPageResponse<SearchResult>)searchResults);
                return Response.ok((Object)this.applyPresenters(searchQuery, documentsActionsResult)).build();
            }
            DocumentActionsReport documentActionsReport = new DocumentActionsReport();
            return Response.ok((Object)documentActionsReport).build();
        }
        catch (Exception e) {
            log.error("Unable to retrieve data for Document Action start: {}", (Object)start, (Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
    }

    private DocumentActionsReport applyPresenters(SearchQuery searchQuery, DocumentActionsSearchResult documentsActionsResult) {
        SingleListActionsPresenter singleListActionsPresenter = new SingleListActionsPresenter();
        PaginatingAndSortingActionsPresenter paginationSortingPresenter = new PaginatingAndSortingActionsPresenter(searchQuery);
        DocumentActionsReport documentActionsReport = singleListActionsPresenter.present(documentsActionsResult);
        return paginationSortingPresenter.present(documentActionsReport);
    }
}

