/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.dataextractor.extractor;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.dataextractor.model.ApprovalContentPropertyModel;
import com.comalatech.confluence.dataextractor.model.FullWorklfowsContentPropertyModel;
import com.comalatech.confluence.dataextractor.model.UserContentPropertyModel;
import com.comalatech.confluence.dataextractor.model.UserContentPropertyModelBuilder;
import com.comalatech.confluence.dataextractor.model.UserKeyListContentProperty;
import com.comalatech.confluence.dataextractor.model.WorkflowsContentPropertyModel;
import com.comalatech.confluence.dataextractor.model.version.GlobalContentPropertyModelVersion;
import com.comalatech.confluence.dataextractor.model.version.WorkflowsContentPropertyModelVersion;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.DecoratedApprovalCheck;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.model.Approval;
import com.comalatech.workflow.model.Completion;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowsPropertyExtractor {
    private static final Logger log = LoggerFactory.getLogger(WorkflowsPropertyExtractor.class);
    private final WorkflowAccessor workflowAccessor;
    private final StateService stateService;
    private final ApprovalManager approvalManager;
    private final ApprovalAccessor approvalAccessor;
    private final PageManager pageManager;
    private final UserAccessor userAccessor;
    private final BootstrapManager bootstrapManager;
    private final WorkflowUserAccessor workflowUserAccessor;
    private final StateAccessor stateAccessor;
    private final ObjectMapper mapper;

    public WorkflowsPropertyExtractor(WorkflowAccessor workflowAccessor, StateService stateService, ApprovalManager approvalManager, @ComponentImport PageManager pageManager, @ComponentImport UserAccessor userAccessor, @ComponentImport BootstrapManager bootstrapManager, WorkflowUserAccessor workflowUserAccessor, ApprovalAccessor approvalAccessor, StateAccessor stateAccessor) {
        this.workflowAccessor = workflowAccessor;
        this.stateService = stateService;
        this.approvalManager = approvalManager;
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
        this.bootstrapManager = bootstrapManager;
        this.workflowUserAccessor = workflowUserAccessor;
        this.approvalAccessor = approvalAccessor;
        this.stateAccessor = stateAccessor;
        this.mapper = new ObjectMapper();
        this.mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        this.mapper.disable(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS});
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.mapper.setDateFormat((DateFormat)df);
    }

    public FullWorklfowsContentPropertyModel getFullWorkflowsContentPropertyModel(AbstractPage page) {
        Workflow workflow;
        WorkflowsContentPropertyModel wcpModel = new WorkflowsContentPropertyModel();
        FullWorklfowsContentPropertyModel fwcpModel = new FullWorklfowsContentPropertyModel();
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        Workflow workflow2 = workflow = pageWorkflows != null ? pageWorkflows.getFirstWorkflowWithStates() : null;
        if (workflow == null) {
            return null;
        }
        wcpModel.workflowName = workflow.getName();
        wcpModel.hasWorkflow = Boolean.toString(true);
        PageState pageCurrentState = (PageState)this.stateService.getCurrentState((ContentEntityObject)page);
        if (Objects.nonNull(pageCurrentState)) {
            this.extractPageStateData(wcpModel, pageCurrentState);
            for (DecoratedApprovalCheck approvalCheck : this.approvalManager.getDecoratedApprovalChecks(pageWorkflows, false, false)) {
                this.extractApprovalData(fwcpModel, approvalCheck);
            }
            this.extractFinalStateData(fwcpModel, wcpModel, page, pageCurrentState);
        }
        wcpModel.hasApprovals = Boolean.toString(!fwcpModel.approvals.isEmpty());
        wcpModel.hasTasks = Boolean.toString(Objects.nonNull(pageCurrentState) && !pageCurrentState.getAllTasks().isEmpty());
        fwcpModel.workflowsContentPropertyModel = wcpModel;
        return fwcpModel;
    }

    private void extractPageStateData(WorkflowsContentPropertyModel wcpModel, PageState pageState) {
        wcpModel.currentState = pageState.getState();
        wcpModel.currentStateColour = pageState.getColour();
        wcpModel.currentStateStartedBy = pageState.getPerformer();
        wcpModel.currentStateStartedByInfo = this.createUserObject(pageState.getPerformer());
        wcpModel.currentStateStart = pageState.getDate().getTime();
        wcpModel.isFinal = Boolean.toString(pageState.isPublished());
        Long l = wcpModel.dueDate = pageState.getExpirationDate() != null ? Long.valueOf(pageState.getExpirationDate().getTime()) : null;
        if (wcpModel.currentStateStartedByInfo != null) {
            wcpModel.currentStateStartedByUserKey = wcpModel.currentStateStartedByInfo.userKeyProperty;
        }
    }

    private void extractApprovalData(FullWorklfowsContentPropertyModel fwcpModel, DecoratedApprovalCheck approvalCheck) {
        ApprovalContentPropertyModel approvalObj = new ApprovalContentPropertyModel(approvalCheck.getName());
        UserKeyListContentProperty approvalPendingApprovers = UserKeyListContentProperty.empty();
        if (approvalCheck.isApproved()) {
            fwcpModel.approvedApprovals.getApprovalNameList().add(approvalCheck.getName());
            fwcpModel.finishedApprovers.getUserKeyList().addAll(this.getFinishedApprovers(approvalCheck, true));
            approvalObj.status = "approved";
        } else if (approvalCheck.isRejected()) {
            fwcpModel.rejectedApprovals.getApprovalNameList().add(approvalCheck.getName());
            fwcpModel.finishedApprovers.getUserKeyList().addAll(this.getFinishedApprovers(approvalCheck, false));
            approvalObj.status = "rejected";
        } else {
            fwcpModel.pendingApprovals.getApprovalNameList().add(approvalCheck.getName());
            approvalObj.status = "pending";
            Set<String> pendingApprovers = approvalCheck.getPendingAssignments().stream().map(pendingAssignment -> this.getUserContentIdFromName(pendingAssignment.getAssignee())).filter(Objects::nonNull).collect(Collectors.toSet());
            fwcpModel.pendingApprovers.getUserKeyList().addAll(pendingApprovers);
            approvalPendingApprovers = UserKeyListContentProperty.fromKeys(pendingApprovers);
            fwcpModel.finishedApprovers.getUserKeyList().addAll(this.getFinishedApprovers(approvalCheck, true));
            fwcpModel.finishedApprovers.getUserKeyList().addAll(this.getFinishedApprovers(approvalCheck, false));
        }
        ArrayList<ApprovalContentPropertyModel.CompletedContentPropertyModel> completed = new ArrayList<ApprovalContentPropertyModel.CompletedContentPropertyModel>();
        if (approvalCheck.isUpToDate() && approvalCheck.getApprovalCheck() != null) {
            for (Completion completion : approvalCheck.getApprovalCheck().getCompletions()) {
                completed.add(new ApprovalContentPropertyModel.CompletedContentPropertyModel(this.getUserContentIdFromName(completion.getPerformer()), completion.getOutcome(), Long.toString(completion.getDate().getTime())));
            }
        }
        approvalObj.pendingApprovers = approvalPendingApprovers;
        approvalObj.completed = completed;
        approvalObj.hasCondition = this.hasApprovalConditions(approvalCheck);
        fwcpModel.approvals.add(approvalObj);
    }

    @NotNull
    private Set<String> getFinishedApprovers(DecoratedApprovalCheck approvalCheck, boolean approved) {
        return approvalCheck.getUpdatedFinishedApprovers(approved).stream().map(approval -> this.getUserContentIdFromName(approval.getUserName())).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private void extractFinalStateData(FullWorklfowsContentPropertyModel fwcpModel, WorkflowsContentPropertyModel wcpModel, AbstractPage page, PageState pageCurrentState) {
        boolean isFinal = pageCurrentState.isPublished();
        PageState publishedState = isFinal ? pageCurrentState : (PageState)this.stateService.getPublishedState((ContentEntityObject)page);
        if (publishedState != null) {
            this.fillLastFinalVersion(wcpModel, publishedState);
            wcpModel.lastFinalVersionDate = publishedState.getDate().getTime();
            PageState previousStateToFinalState = this.stateAccessor.getPreviousStateToFinalState(page, publishedState);
            List<ApprovalCheck> approvalchecks = this.approvalAccessor.getApprovalChecksBeforeLastFinalState(page, previousStateToFinalState);
            if (!approvalchecks.isEmpty()) {
                for (ApprovalCheck approvalCheck : approvalchecks) {
                    if (approvalCheck.getStateId() != publishedState.getId() - 1) continue;
                    for (Approval approver : approvalCheck.getApprovals()) {
                        String userContent;
                        if (!approver.isApproved() || (userContent = this.getUserContentIdFromName(approver.getPerformer())) == null) continue;
                        fwcpModel.lastFinalVersionApprovers.getUserKeyList().add(userContent);
                    }
                }
            } else {
                fwcpModel.lastFinalVersionApprovers = UserKeyListContentProperty.empty();
            }
        } else {
            wcpModel.lastFinalVersionId = null;
            wcpModel.lastFinalVersionNumber = null;
            wcpModel.lastFinalVersionDate = null;
            fwcpModel.lastFinalVersionApprovers = UserKeyListContentProperty.empty();
        }
    }

    private void fillLastFinalVersion(WorkflowsContentPropertyModel cpModel, PageState publishedState) {
        AbstractPage finalVersionPage;
        if (publishedState != null && publishedState.getPage() != null && (finalVersionPage = this.pageManager.getPageByVersion(publishedState.getPage(), publishedState.getVersion())) != null) {
            cpModel.lastFinalVersionId = (int)finalVersionPage.getId();
            cpModel.lastFinalVersionNumber = "v" + finalVersionPage.getVersion();
            return;
        }
        cpModel.lastFinalVersionId = null;
        cpModel.lastFinalVersionNumber = null;
    }

    private UserContentPropertyModel createUserObject(String username) {
        if (username != null) {
            ConfluenceUser confluenceUser = this.userAccessor.getUserByName(username);
            if (confluenceUser != null) {
                ProfilePictureInfo picture;
                String userKey = confluenceUser.getKey().getStringValue();
                if (log.isDebugEnabled()) {
                    log.debug("creating UserContent for user: " + confluenceUser.getName());
                }
                if ((picture = this.userAccessor.getUserProfilePicture((User)confluenceUser)) != null) {
                    String path = this.bootstrapManager.getWebAppContextPath() + picture.getDownloadPath();
                    return new UserContentPropertyModelBuilder().withUserName(confluenceUser.getName()).withDisplayName(confluenceUser.getFullName()).withPath(path).withUserKey(userKey).withShowAsLink(true).build();
                }
                return new UserContentPropertyModelBuilder().withUserName(confluenceUser.getName()).withDisplayName(confluenceUser.getFullName()).withPath(userKey).withShowAsLink(true).build();
            }
            if ("com.comalatech.workflow".equals(username)) {
                if (log.isDebugEnabled()) {
                    log.debug("creating UserContent for user: com.comalatech.workflow");
                }
                return new UserContentPropertyModelBuilder().withUserName("com.comalatech.workflow").withDisplayName("Comala Document Management").withPath(this.workflowUserAccessor.getWorkflowUserAvatarPath()).withShowAsLink(false).build();
            }
            if (log.isDebugEnabled()) {
                log.debug("can not create UserContent, user not found: " + username);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("can not create UserContent from a null username");
        }
        return null;
    }

    private String getUserContentIdFromName(String name) {
        ConfluenceUser userByName = this.userAccessor.getUserByName(name);
        if (userByName != null) {
            return userByName.getKey().getStringValue();
        }
        return null;
    }

    public <T> String serialize(T data) {
        try {
            return this.mapper.writeValueAsString(data);
        }
        catch (Exception e) {
            String className = data == null ? "" : data.getClass().getSimpleName();
            log.error(className + " could not be serialized", (Throwable)e);
            return null;
        }
    }

    public String getCurrentWorkflowsModelVersionJson() {
        String serializedWorkflowsVersion = this.serialize(WorkflowsContentPropertyModelVersion.getCurrentVersion());
        return serializedWorkflowsVersion == null ? "" : serializedWorkflowsVersion;
    }

    public String getCurrentGlobalModelVersionJson() {
        String serializedGlobalVersion = this.serialize(GlobalContentPropertyModelVersion.getCurrentVersion());
        return serializedGlobalVersion == null ? "" : serializedGlobalVersion;
    }

    private boolean hasApprovalConditions(DecoratedApprovalCheck approvalCheck) {
        com.comalatech.confluence.workflow.model.Approval approval = approvalCheck.getApproval();
        if (approval != null) {
            List<Condition> conditions = approval.getConditions();
            return conditions.stream().anyMatch(approval.hasUserCondition().negate().and(approval.hasApproverCondition().negate()).and(approval.hasGroupCondition().negate()).and(approval.hasViewPermissionCondition().negate()));
        }
        return false;
    }
}

