/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.listener;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.ConfluenceSpaceContainerV1;
import com.atlassian.migration.app.ContainerType;
import com.atlassian.migration.app.PaginatedContainers;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.MigrationEntity;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GenerateCloudMappings;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivityMigrationData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.Presenter;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class WorkflowsCloudMigrationListener
implements DiscoverableListener {
    private static final Logger log = LoggerFactory.getLogger(WorkflowsCloudMigrationListener.class);
    private final PluginLicenseManager licenseManager;
    private final Presenter<File> fileJsonPresenter;
    private final Presenter<String> jsonPresenter;
    private final GeneratePageActivityMigrationData pageActivityGeneratorUseCase;
    private final GenerateCloudMappings generateCloudMappings;
    private final ObjectMapper objectMapper;
    private static final int SPACE_CONTAINERS_BATCH = 50;

    public WorkflowsCloudMigrationListener(@ComponentImport PluginLicenseManager pluginLicenseManager, @Qualifier(value="fileJsonPresenter") Presenter<File> fileJsonPresenter, @Qualifier(value="jsonPresenter") Presenter<String> jsonPresenter, GeneratePageActivityMigrationData generatePageActivity, GenerateCloudMappings generateCloudMappings) {
        this.licenseManager = pluginLicenseManager;
        this.fileJsonPresenter = fileJsonPresenter;
        this.jsonPresenter = jsonPresenter;
        this.pageActivityGeneratorUseCase = generatePageActivity;
        this.generateCloudMappings = generateCloudMappings;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public void onStartAppMigration(AppCloudMigrationGateway gateway, String transferId, MigrationDetailsV1 migrationDetails) {
        try {
            List<MigrationEntity> migrationEntities;
            log.info("Migration context summary: " + this.objectMapper.writeValueAsString((Object)migrationDetails));
            HashMap<AbstractPage, List<Activity>> pageActivitiesMap = new HashMap<AbstractPage, List<Activity>>();
            PaginatedContainers paginatedSiteContainers = gateway.getPaginatedContainers(transferId, ContainerType.ConfluenceSpace, 50);
            while (paginatedSiteContainers.next()) {
                List<String> spaceKeys = paginatedSiteContainers.getContainers().stream().filter(container -> container instanceof ConfluenceSpaceContainerV1).map(container -> ((ConfluenceSpaceContainerV1)container).getKey()).collect(Collectors.toList());
                pageActivitiesMap.putAll(this.pageActivityGeneratorUseCase.generatePageCurrentActivityForSpace(spaceKeys));
            }
            Migration migration = this.generateCloudMappings.generateMigrationData(gateway, pageActivitiesMap, transferId, migrationDetails);
            if (log.isDebugEnabled() && (migrationEntities = migration.migrationEntities) != null) {
                log.debug("Number of entities to send:" + migrationEntities.size());
                for (MigrationEntity entity : migrationEntities) {
                    if (entity == null) continue;
                    log.debug("Activities for migration entity: " + entity.getContentId());
                    for (com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity activity : entity.getActivities()) {
                        log.debug("Activity: " + this.jsonPresenter.present(activity));
                    }
                }
            }
            File jsonActivities = this.fileJsonPresenter.present(migration);
            log.info("Sending {} bytes of data for transferId {} ", (Object)jsonActivities.length(), (Object)transferId);
            this.sendActivitiesToMigrationService(gateway, transferId, jsonActivities);
        }
        catch (Exception e) {
            log.error("Error during the migration process", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void sendActivitiesToMigrationService(AppCloudMigrationGateway gateway, String transferId, File jsonActivities) throws IOException {
        OutputStream atlassianMigrationDataStream = gateway.createAppData(transferId);
        InputStream activitiesDataStream = Files.newInputStream(jsonActivities.toPath(), new OpenOption[0]);
        IOUtils.copy((InputStream)activitiesDataStream, (OutputStream)atlassianMigrationDataStream);
        atlassianMigrationDataStream.close();
    }

    @Override
    public String getCloudAppKey() {
        return this.licenseManager.getPluginKey();
    }

    @Override
    public String getServerAppKey() {
        return this.licenseManager.getPluginKey();
    }

    @Override
    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_PRODUCT, AccessScope.MIGRATION_TRACING_IDENTITY).collect(Collectors.toCollection(HashSet::new));
    }
}

