/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivity;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivityMigrationData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.ValidatePageActivity;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GenerateValidatedPageActivityMigrationData
implements GeneratePageActivityMigrationData {
    private static final Logger log = LoggerFactory.getLogger(GenerateValidatedPageActivityMigrationData.class);
    private final GeneratePageActivity generatePageActivity;
    private final ValidatePageActivity validatePageActivity;
    private final SpaceManager spaceManager;
    private final PageManager pageManager;

    public GenerateValidatedPageActivityMigrationData(GeneratePageActivity generatePageActivity, ValidatePageActivity validatePageActivity, @ComponentImport SpaceManager spaceManager, @ComponentImport PageManager pageManager) {
        this.generatePageActivity = generatePageActivity;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.validatePageActivity = validatePageActivity;
    }

    @Override
    public Map<AbstractPage, List<Activity>> generatePageActivitiesForSpace(List<String> spaceKeysList) {
        HashMap<AbstractPage, List<Activity>> result = new HashMap<AbstractPage, List<Activity>>();
        for (String currentSpace : spaceKeysList) {
            Space space = this.spaceManager.getSpace(currentSpace);
            if (space == null) continue;
            Stream pages = this.pageManager.getPages(space, false).stream();
            Stream blogs = this.pageManager.getBlogPosts(space, false).stream();
            Stream pageStream = Stream.concat(pages, blogs);
            pageStream.forEach(currentPage -> {
                List<Activity> activities = this.generatePageActivity.generateActivity((AbstractPage)currentPage);
                boolean isValidActivity = this.validatePageActivity.validateActivity((AbstractPage)currentPage, activities, false);
                if (!activities.isEmpty() && isValidActivity) {
                    result.put((AbstractPage)currentPage, activities);
                } else {
                    log.info("Page id {} not added to page activities list: list empty ? {}, is valid? {} ", new Object[]{currentPage.getId(), activities.isEmpty(), isValidActivity});
                }
            });
        }
        return result;
    }

    @Override
    public Map<AbstractPage, List<Activity>> generatePageCurrentActivityForSpace(List<String> spaceKeysList) {
        HashMap<AbstractPage, List<Activity>> result = new HashMap<AbstractPage, List<Activity>>();
        AtomicInteger totalPages = new AtomicInteger(0);
        ArrayList pagesNotExported = new ArrayList();
        for (String currentSpace : spaceKeysList) {
            Space space = this.spaceManager.getSpace(currentSpace);
            if (space == null) continue;
            Stream pages = this.pageManager.getPages(space, false).stream();
            Stream blogs = this.pageManager.getBlogPosts(space, false).stream();
            Stream pageStream = Stream.concat(pages, blogs);
            pageStream.filter(p -> !p.isDraft()).forEach(currentPage -> {
                totalPages.incrementAndGet();
                List<Activity> activities = this.generatePageActivity.generateCurrentActivity((AbstractPage)currentPage);
                if (!activities.isEmpty()) {
                    result.put((AbstractPage)currentPage, activities);
                } else {
                    pagesNotExported.add(currentPage.getId());
                    log.error("Page id {} not added to page activities list: list empty ? {}", (Object)currentPage.getId(), (Object)activities.isEmpty());
                }
            });
            if (pagesNotExported.isEmpty()) {
                log.info(totalPages.get() + " pages of space " + space.getName() + " have been successfully exported");
            } else {
                log.error(totalPages.get() - pagesNotExported.size() + " of " + totalPages.get() + " pages of space " + space.getName() + " have been successfully exported");
                log.error("The following pages, " + pagesNotExported.size() + " in total, failed to be exported: " + Arrays.toString(pagesNotExported.toArray()));
            }
            totalPages.set(0);
            pagesNotExported.clear();
        }
        return result;
    }
}

