/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.rest.resources;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.comalatech.confluence.cloud.migration.rest.model.WorkflowUsageReportResult;
import com.comalatech.confluence.cloud.migration.rest.model.WorkflowsUsageReportDTO;
import com.comalatech.confluence.cloud.migration.service.WorkflowsUsageReportService;
import com.comalatech.confluence.cloud.migration.service.model.WorkflowsUsageReport;
import com.comalatech.confluence.util.validators.PermissionValidator;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/report/workflowsusage")
@Produces(value={"application/json"})
public class WorkflowUsageResource {
    private static final Logger log = LoggerFactory.getLogger(WorkflowUsageResource.class);
    private final PermissionValidator permissionValidator;
    private final WorkflowsUsageReportService workflowsUsageReportService;

    public WorkflowUsageResource(@Qualifier(value="adminPermissionValidator") PermissionValidator permissionValidator, WorkflowsUsageReportService workflowsUsageReportService) {
        this.permissionValidator = permissionValidator;
        this.workflowsUsageReportService = workflowsUsageReportService;
    }

    @GET
    @ReadOnlyAccessAllowed
    @PermissionRequired(value={"ADMINISTER"})
    @ApiResponses(value={@ApiResponse(code=200, message="Workflow report was queried successfully"), @ApiResponse(code=401, message="Client is not authenticated"), @ApiResponse(code=403, message="User has not administrator permissions"), @ApiResponse(code=500, message="Exception when trying to retrieve data for workflow usage report")})
    public Response get(@DefaultValue(value="space") @QueryParam(value="type") String type) {
        try {
            Collection<Annotation> allAnnotations = new PermissionValidator.AnnotationGetterCommand(){}.getAllAnnotations();
            this.permissionValidator.validate(allAnnotations);
            WorkflowUsageReportResult reportResult = new WorkflowUsageReportResult();
            if ("space".equals(type)) {
                reportResult.setWorkflowReports(this.mappingDtoModel(this.workflowsUsageReportService.getSpacesReport()));
            } else {
                reportResult.setWorkflowReports(this.mappingDtoModel(this.workflowsUsageReportService.getPagesReport()));
            }
            return Response.ok((Object)reportResult).build();
        }
        catch (ApplicationPermissionException e) {
            String warningMsg = MessageFormat.format("Permission validation error. {0} ", e.getMessage());
            log.warn(warningMsg);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
        catch (Exception e) {
            String errorMsg = MessageFormat.format("Unable to retrieve data for Workflow usage Report for this type: {0}", type);
            log.error(errorMsg, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
    }

    private List<WorkflowsUsageReportDTO> mappingDtoModel(List<WorkflowsUsageReport> spacesReport) {
        return spacesReport.stream().map(workflowsUsageReport -> WorkflowsUsageReportDTO.builder().spaceKey(workflowsUsageReport.getSpace().getSpaceKey()).spaceName(workflowsUsageReport.getSpace().getSpaceName()).workflowName(workflowsUsageReport.getWorkflow().getName()).workflowId(workflowsUsageReport.getWorkflow().getHandle()).type(workflowsUsageReport.getType()).cloudCompatible(workflowsUsageReport.getIsCloudCompatible()).build()).collect(Collectors.toList());
    }
}

