/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhocworkflows.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhocworkflows.rest.AbstractAdhocResources;
import com.comalatech.confluence.adhocworkflows.rest.model.Approval;
import com.comalatech.confluence.adhocworkflows.rest.model.Approver;
import com.comalatech.confluence.adhocworkflows.rest.model.Template;
import com.comalatech.confluence.adhocworkflows.rest.model.TemplateTranslation;
import com.comalatech.confluence.adhocworkflows.rest.model.Templates;
import com.comalatech.confluence.adhocworkflows.rest.model.TemplatesTranslation;
import com.comalatech.confluence.adhocworkflows.rest.model.User;
import com.comalatech.confluence.adhocworkflows.rest.model.WorkflowAction;
import com.comalatech.confluence.encryption.AESEncryptionException;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.workflow.DefaultApprovalRolesManager;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.esignatures.ao.entity.BaseSigningTokenRecord;
import com.comalatech.confluence.workflow.esignatures.configuration.ESignaturesConfigurationManager;
import com.comalatech.confluence.workflow.esignatures.service.ESignaturesService;
import com.comalatech.confluence.workflow.model.DecoratedApprovalCheck;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.confluence.workflowcontainer.model.RequireApprovalComment;
import com.comalatech.workflow.WorkflowHandler;
import com.comalatech.workflow.model.Action;
import com.comalatech.workflow.model.ApprovalAction;
import com.comalatech.workflow.model.AssignedApprover;
import com.comalatech.workflow.model.FormAction;
import com.comalatech.workflow.model.PageStatus;
import com.comalatech.workflow.model.SelectionAction;
import com.comalatech.workflow.model.Workflow;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class AbstractContentWorkflowResources
extends AbstractAdhocResources {
    private static final Logger log = LoggerFactory.getLogger(AbstractContentWorkflowResources.class);
    protected final WikiStyleRenderer wikiStyleRenderer;
    protected final InternalWorkflowParameterManager workflowParameterManager;
    protected final AdhocWorkflowManager adhocWorkflowManager;
    protected final WorkflowTemplateManager workflowTemplateManager;
    protected final WorkflowAccessor workflowAccessor;
    protected final WorkflowContainerManager workflowContainerManager;
    protected final ESignaturesConfigurationManager eSignaturesConfigurationManager;
    protected final ESignaturesService eSignaturesService;
    protected final DefaultApprovalRolesManager defaultApprovalRolesManager;

    public AbstractContentWorkflowResources(PageManager pageManager, PermissionManager permissionManager, WorkflowPermissionManager workflowPermissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, AccessModeService accessModeService, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowHandler workflowHandler, UserSearchManager userSearchManager, BootstrapManager bootstrapManager, WikiStyleRenderer wikiStyleRenderer, InternalWorkflowParameterManager workflowParameterManager, AdhocWorkflowManager adhocWorkflowManager, @Qualifier(value="workflowTemplateManager") WorkflowTemplateManager workflowTemplateManager, WorkflowAccessor workflowAccessor, WorkflowContainerManager workflowContainerManager, ESignaturesConfigurationManager eSignaturesConfigurationManager, ESignaturesService eSignaturesService, DefaultApprovalRolesManager defaultApprovalRolesManager, ComalaI18nBean comalaI18nBean) {
        super(pageManager, permissionManager, workflowPermissionManager, spaceManager, spacePermissionManager, accessModeService, workflowsFeatureManager, workflowConfigurationManager, workflowHandler, userSearchManager, bootstrapManager, comalaI18nBean);
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.workflowParameterManager = workflowParameterManager;
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.workflowTemplateManager = workflowTemplateManager;
        this.workflowAccessor = workflowAccessor;
        this.workflowContainerManager = workflowContainerManager;
        this.eSignaturesConfigurationManager = eSignaturesConfigurationManager;
        this.eSignaturesService = eSignaturesService;
        this.defaultApprovalRolesManager = defaultApprovalRolesManager;
    }

    protected <T> T getTemplates(AbstractPage page) {
        List<Workflow> allTemplates = this.getWorkflowTemplates(page);
        if (this.workflowsFeatureManager.isWorkflowsLiteApp()) {
            TemplatesTranslation templatesTranslation = new TemplatesTranslation();
            for (Workflow template : allTemplates) {
                String workflowName = StringUtils.deleteWhitespace((String)template.getName()).toLowerCase();
                String nameTranslation = this.comalaI18nBean.getText("workflow.picker.name." + workflowName);
                String descriptionTranslation = this.comalaI18nBean.getText("workflow.picker.description." + workflowName);
                templatesTranslation.add(new TemplateTranslation(template, this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)page.toPageContext(), template.getDescription()), template.getWorkflowStates(), nameTranslation, descriptionTranslation));
            }
            return (T)templatesTranslation;
        }
        Templates templates = new Templates();
        for (Workflow template : allTemplates) {
            templates.add(new Template(template.getName(), template.getDescription(), this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)page.toPageContext(), template.getDescription()), template.getWorkflowStates()));
        }
        return (T)templates;
    }

    protected WorkflowAction makeWorkflowAction(AbstractPage page, boolean admin, boolean includeNonAssignedApprovers, boolean publishedView) {
        Templates templates;
        if (log.isDebugEnabled()) {
            log.debug("creating workflow actions for page: " + page + "   admin: " + admin + " appendRecentApprovers: " + includeNonAssignedApprovers);
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        boolean canAdminister = this.canAdminWorkflow(page, (com.atlassian.user.User)user);
        List<Action> actions = this.workflowHandler.getActions((ContentEntityObject)page, user, admin);
        WorkflowAction workflowAction = new WorkflowAction();
        boolean hasApprovals = false;
        boolean hasSelection = false;
        boolean requireApprovalComment = this.workflowConfigurationManager.getRequireApprovalComment(true) == RequireApprovalComment.REQUIRE;
        String eSignature = this.eSignaturesConfigurationManager.getESignaturesCredentials().toUpperCase();
        boolean hasSigning = this.hasSigningRecord(user);
        boolean hasContributors = false;
        boolean isRolesEnabled = false;
        for (Action action : actions) {
            if (action instanceof SelectionAction && !hasApprovals) {
                workflowAction.setStates(((SelectionAction)action).getStates());
                workflowAction.setAdhoc(((SelectionAction)action).isAdhoc());
                hasSelection = true;
                continue;
            }
            if (action instanceof ApprovalAction && !hasSelection) {
                Approval approval;
                ApprovalAction approvalAction = (ApprovalAction)action;
                List<Approval> approvals = workflowAction.getApprovals();
                if (approvals == null) {
                    approvals = new ArrayList<Approval>();
                    workflowAction.setApprovals(approvals);
                }
                if ((approval = new Approval(approvalAction)).isRolesEnabled()) {
                    isRolesEnabled = true;
                }
                HashSet<String> approversSet = new HashSet<String>();
                for (AssignedApprover assignment : approvalAction.getAssignments()) {
                    String rolename;
                    String assignedApproverName = assignment.getAssignee();
                    User assignedApprover = this.userSearchManager.makeUser(assignedApproverName, rolename = approvalAction instanceof DecoratedApprovalCheck ? ((DecoratedApprovalCheck)approvalAction).getRolename(assignedApproverName) : null);
                    if (assignedApprover != null) {
                        assignedApproverName = assignedApprover.getName();
                    } else {
                        assignedApprover = new User(assignedApproverName, rolename, assignedApproverName, this.getDeletedUserIcon());
                    }
                    boolean canRemove = (approvalAction.getSelector() == null || !approvalAction.getSelector().isFixed()) && (canAdminister || user != null && user.getName().equals(approvalAction.getAssignerUserName(assignedApproverName)));
                    approversSet.add(assignedApproverName);
                    Approver approver = new Approver(assignedApprover, assignment, canRemove);
                    approver.setComment(assignment.getComment());
                    approval.addApprover(approver);
                }
                if (includeNonAssignedApprovers) {
                    List<com.comalatech.workflow.model.Approval> pastApprovals = approvalAction.getMostRecentApprovalsOnly();
                    for (com.comalatech.workflow.model.Approval pastApproval : pastApprovals) {
                        if (approversSet.contains(pastApproval.getPerformer())) continue;
                        Approver recentApprover = new Approver();
                        recentApprover.setUser(this.userSearchManager.makeUser(pastApproval.getPerformer()));
                        recentApprover.setApproved(pastApproval.isApproved());
                        recentApprover.setRejected(!recentApprover.isApproved());
                        recentApprover.setCanApprove(false);
                        recentApprover.setCanReject(false);
                        recentApprover.setComment(pastApproval.getComment());
                        recentApprover.setPast(true);
                        approval.addApprover(recentApprover);
                    }
                }
                approvals.add(approval);
                if (approval.isCanAssign()) {
                    hasContributors = true;
                }
                hasApprovals = true;
                continue;
            }
            if (!(action instanceof FormAction)) continue;
            FormAction formAction = (FormAction)action;
            if (formAction.isInitialized()) {
                workflowAction.setHasParameters(true);
            } else {
                workflowAction.setShowParameters(true);
                boolean workflowHasRequiredParams = this.workflowParameterManager.hasParametersForTransition(page);
                workflowAction.setInitParameters(!workflowHasRequiredParams);
            }
            workflowAction.setInputFields(formAction.getInputFields());
        }
        PageStatus state = this.workflowHandler.getPageStatus((ContentEntityObject)page, publishedView, true);
        if (state != null) {
            workflowAction.setPageStatus(state);
            workflowAction.setTasksAllowed(state.isTaskable());
        } else {
            workflowAction.setTasksAllowed(this.adhocWorkflowManager.isAdhocWorkflowAllowed(page));
        }
        if ((state == null || this.workflowAccessor.hasHiddenStatesPageWorkflow((ContentEntityObject)page)) && (templates = (Templates)this.getTemplates(page)).getTemplates().size() > 0) {
            workflowAction.setTemplates(templates.getTemplates());
        }
        workflowAction.setInvolvedUsers(this.makeInvolvedUsers(this.workflowHandler.getInvolvedUsers((ContentEntityObject)page)));
        workflowAction.setSpaceKey(page.getSpaceKey());
        workflowAction.setSpaceAdmin(this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", page.getSpace(), (com.atlassian.user.User)user));
        workflowAction.setRequireApprovalComment(requireApprovalComment);
        workflowAction.setContributors(this.userSearchManager.getContributors(page, hasContributors));
        workflowAction.setESignature(eSignature);
        workflowAction.setHasSigning(hasSigning);
        if (isRolesEnabled) {
            workflowAction.setRoles(this.defaultApprovalRolesManager.getApprovalRoles(page.getSpaceKey()));
        }
        if (log.isDebugEnabled()) {
            log.debug("finished creating actions on page: " + page);
        }
        return workflowAction;
    }

    protected List<Workflow> getWorkflowTemplates(AbstractPage page) {
        ArrayList<Workflow> activeTemplates = new ArrayList<Workflow>();
        for (Workflow template : this.workflowTemplateManager.getWorkflowTemplates(page.getSpace())) {
            if (!template.isActive()) continue;
            activeTemplates.add(template);
        }
        for (Workflow template : this.workflowTemplateManager.getWorkflowTemplates()) {
            if (!template.isActive() || !this.workflowContainerManager.isGlobalWorkflowTemplateActive(page.getSpaceKey(), template.getName())) continue;
            activeTemplates.add(template);
        }
        return activeTemplates;
    }

    private boolean hasSigningRecord(ConfluenceUser user) {
        boolean hasSigning = false;
        if (!this.workflowsFeatureManager.isApprovalsApp()) {
            BaseSigningTokenRecord baseSigningTokenRecord = null;
            try {
                baseSigningTokenRecord = this.eSignaturesService.getSigningTokenRecord(user.getKey().getStringValue());
            }
            catch (AESEncryptionException e) {
                log.error("Error parsing user OTP secret key, removing key for user: " + user.getKey().getStringValue());
                this.eSignaturesService.purgeSigningToken(user.getKey().getStringValue());
            }
            if (baseSigningTokenRecord == null) {
                hasSigning = false;
            } else if (TimerUtils.isDateExpired(baseSigningTokenRecord.getExpiryTimestamp())) {
                try {
                    this.eSignaturesService.purgeSigningToken(user.getKey().getStringValue());
                }
                catch (Exception e) {
                    log.warn("There was an error trying to remove the secret key");
                }
                hasSigning = false;
            } else {
                hasSigning = true;
            }
        }
        return hasSigning;
    }
}

