/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification.model;

import com.comalatech.confluence.adhoc.notification.model.Notification;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import org.springframework.web.util.HtmlUtils;

public class StateExpiredNotification
extends Notification {
    public static final String STATE_NAME = "stateName";
    public static final String PAGE_TITLE_KEY = "pageTitle";
    public static final String PAGE_PATH_KEY = "pagePath";

    @Override
    public String getSubject() {
        return HtmlUtils.htmlEscape((String)ComalaI18nBean.getComalaI18nBean().getText("com.comalatech.state.notification.expired.subject", new String[]{(String)this.getContextProperties().get(STATE_NAME), (String)this.getContextProperties().get(PAGE_TITLE_KEY)}));
    }

    @Override
    public String getTemplateName() {
        return "state-expired";
    }

    @Override
    public String getBody(Notification.MessageSystem notificationMessageSystem) {
        String stateName = HtmlUtils.htmlEscape((String)((String)this.getContextProperties().get(STATE_NAME)));
        String title = (String)this.getContextProperties().get(PAGE_TITLE_KEY);
        String path = HtmlUtils.htmlEscape((String)(this.getBaseUrl() + this.getContextProperties().get(PAGE_PATH_KEY).toString()));
        switch (notificationMessageSystem) {
            case EMAIL: {
                String description = (String)this.getContextProperties().get("activityDescription");
                return ComalaI18nBean.getComalaI18nBean().getText(description, new String[]{stateName, path, title});
            }
            case SLACK: {
                String description = (String)this.getContextProperties().get("slackActivityDescription");
                return ComalaI18nBean.getComalaI18nBean().getText(description, new String[]{stateName, path, title});
            }
        }
        throw new IllegalArgumentException("Type notification not valid");
    }
}

