/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.dao;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.dao.AdhocWorkflowDao;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultAdhocWorkflowDao
implements AdhocWorkflowDao {
    private static final Logger log = LoggerFactory.getLogger(DefaultAdhocWorkflowDao.class);
    private static final String CDM_TEMPLATE_KEY_PREFIX = "com.comalatech.workflow.template.";
    private static final String CDC_TEMPLATE_KEY_PREFIX = "com.comalatech.workflow.lite.template.";
    private static final String WORKFLOW_TEMPLATE_LINKED_SPACES_PREFIX = "com.comalatech.workflow.linkedspaces.";
    private static final String WORKFLOW_TEMPLATE_LINKED_LABELS_PREFIX = "com.comalatech.workflow.linkedlabels.";
    private static final String GLOBAL_WORKFLOW_ACTIVE_FLAG_PREFIX = "com.comalatech.workflow.active.";
    private static final String GLOBAL_WORKFLOW_SAMPLE_FLAG_PREFIX = "com.comalatech.workflow.global.sample.";
    private static final String ACTIVE = "active.";
    private static final String TEMPLATE = "template.";
    private static final String PRODUCTION_WORKFLOW_VERSION_KEY = "com.comalatech.workflow.production.version";
    private final String GLOBAL_WORKFLOW_SPACE_KEY = "com.comalatech.global.space.key";
    private final String WORKFLOW_TEMPLATE_BACKUP = "com.comalatech.worflow.backup.";
    private final String GLOBAL_WORKFLOW_TEMPLATE_BACKUP = "com.comalatech.worflow.global.backup.";
    public static final int BANDANA_KEY_MAX_LENGTH = 100;
    private final ComalaPropertiesSetManager contentPropertyManager;
    private final WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager;
    private final BandanaManager bandanaManager;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final ComalaI18nBean comalaI18nBean;
    private Map<String, TemplateNamesCache> workflowTemplates;
    private boolean needToRemoveCDCKeys;

    public DefaultAdhocWorkflowDao(ComalaPropertiesSetManager contentPropertyManager, WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager, @ComponentImport BandanaManager bandanaManager, WorkflowsFeatureManager workflowsFeatureManager, ComalaI18nBean comalaI18nBean) {
        this.contentPropertyManager = contentPropertyManager;
        this.workflowAdvancedConfigurationManager = workflowAdvancedConfigurationManager;
        this.bandanaManager = bandanaManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.comalaI18nBean = comalaI18nBean;
        this.needToRemoveCDCKeys = true;
    }

    @Override
    public void setLinkedTemplate(String spaceKey, String templateName) {
        String globalTemplateSpacesKey = this.makeKey(WORKFLOW_TEMPLATE_LINKED_SPACES_PREFIX, templateName);
        TreeSet<String> linkedSpaces = new TreeSet<String>(this.getStringList(globalTemplateSpacesKey, null));
        linkedSpaces.add(spaceKey);
        this.setStringList(globalTemplateSpacesKey, null, new ArrayList<String>(linkedSpaces));
    }

    @Override
    public void unlinkTemplate(String spaceKey, String templateName) {
        String globalTemplateSpacesKey = this.makeKey(WORKFLOW_TEMPLATE_LINKED_SPACES_PREFIX, templateName);
        List<String> linkedSpaces = this.getStringList(globalTemplateSpacesKey, null);
        linkedSpaces.remove(spaceKey);
        this.setStringList(globalTemplateSpacesKey, null, new ArrayList<String>(linkedSpaces));
    }

    @Override
    public List<String> getLinkedSpaces(String templateName) {
        String globalTemplateSpacesKey = this.makeKey(WORKFLOW_TEMPLATE_LINKED_SPACES_PREFIX, templateName);
        return this.getStringList(globalTemplateSpacesKey, null);
    }

    @Override
    public List<String> getLinkedTemplates(String spaceKey) {
        ArrayList<String> linkedTemplates = new ArrayList<String>();
        if (this.workflowsFeatureManager.isWorkflowsApp()) {
            List<String> templateNames = this.getWorkflowTemplatesNames(null);
            for (String templateName : templateNames) {
                if (!this.getLinkedSpaces(templateName).contains(spaceKey)) continue;
                linkedTemplates.add(templateName);
            }
        }
        return linkedTemplates;
    }

    @Override
    public void setSpaceLabelLink(String label, String templateName) {
        String globalTemplateLabelsKey = this.makeKey(WORKFLOW_TEMPLATE_LINKED_LABELS_PREFIX, templateName);
        TreeSet<String> linkedLabels = new TreeSet<String>(this.getStringList(globalTemplateLabelsKey, null));
        linkedLabels.add(label);
        this.setStringList(globalTemplateLabelsKey, null, new ArrayList<String>(linkedLabels));
    }

    @Override
    public void unlinkSpaceLabel(String label, String templateName) {
        String globalTemplateLabelsKey = this.makeKey(WORKFLOW_TEMPLATE_LINKED_LABELS_PREFIX, templateName);
        List<String> linkedLabels = this.getStringList(globalTemplateLabelsKey, null);
        linkedLabels.remove(label);
        this.setStringList(globalTemplateLabelsKey, null, new ArrayList<String>(linkedLabels));
    }

    @Override
    public List<String> getLinkedLabels(String templateName) {
        String globalTemplateLabelsKey = this.makeKey(WORKFLOW_TEMPLATE_LINKED_LABELS_PREFIX, templateName);
        return this.getStringList(globalTemplateLabelsKey, null);
    }

    @Override
    public List<String> getLinkedLabelTemplates(String label) {
        ArrayList<String> linkedTemplates = new ArrayList<String>();
        List<String> templateNames = this.getWorkflowTemplatesNames(null);
        for (String templateName : templateNames) {
            if (!this.getLinkedLabels(templateName).contains(label)) continue;
            linkedTemplates.add(templateName);
        }
        return linkedTemplates;
    }

    protected List<String> getStringList(String bandanaKey, String spaceKey) {
        BandanaContext context = this.getBandanaContext(spaceKey);
        String[] bandanaValue = (String[])this.bandanaManager.getValue(context, bandanaKey);
        if (bandanaValue != null) {
            return new ArrayList<String>(Arrays.asList(bandanaValue));
        }
        return new ArrayList<String>();
    }

    protected void setStringList(String bandanaKey, String spaceKey, List<String> list) {
        BandanaContext context = this.getBandanaContext(spaceKey);
        this.bandanaManager.setValue(context, bandanaKey, (Object)list.toArray(new String[0]));
    }

    protected BandanaContext getBandanaContext(String spaceKey) {
        ComalatechBandanaContext context = StringUtils.isNotBlank((CharSequence)spaceKey) ? new ConfluenceBandanaContext(spaceKey) : ComalatechBandanaContext.COMALATECH_CONTEXT;
        return context;
    }

    @Override
    public String getWorkflowBody(AbstractPage page) {
        String property;
        String workflowBody = null;
        List<String> properties = this.workflowsFeatureManager.getPageWorkflowPropertyKeys();
        Iterator<String> iterator = properties.iterator();
        while (iterator.hasNext() && !StringUtils.isNotBlank((CharSequence)(workflowBody = this.contentPropertyManager.getTextProperty((ContentEntityObject)page, property = iterator.next())))) {
        }
        return workflowBody;
    }

    @Override
    public void setWorkflowBody(AbstractPage page, String rawWorkflow) {
        List<String> properties = this.workflowsFeatureManager.getPageWorkflowPropertyKeys();
        for (int i = 0; i < properties.size(); ++i) {
            this.contentPropertyManager.setTextProperty((ContentEntityObject)page, properties.get(i), i == 0 ? rawWorkflow : null);
        }
    }

    @Override
    public void removeWorkflowBody(AbstractPage page) {
        List<String> properties = this.workflowsFeatureManager.getPageWorkflowPropertyKeys();
        for (String property : properties) {
            String workflowBody = this.contentPropertyManager.getTextProperty((ContentEntityObject)page, property);
            if (!StringUtils.isNotBlank((CharSequence)workflowBody)) continue;
            this.contentPropertyManager.setTextProperty((ContentEntityObject)page, property, null);
            break;
        }
    }

    private List<String> getKeys(String spaceKey, String prefix) {
        ArrayList<String> keys = new ArrayList<String>();
        BandanaContext comalatechContext = this.getBandanaContext(spaceKey);
        for (String key : this.bandanaManager.getKeys(comalatechContext)) {
            if (!key.startsWith(prefix) || this.bandanaManager.getValue(comalatechContext, key) == null) continue;
            keys.add(key);
        }
        return this.getKeysNames(keys, spaceKey, prefix);
    }

    private List<String> getKeys(String spaceKey) {
        BandanaContext comalatechContext = this.getBandanaContext(spaceKey);
        List<String> prefixes = this.workflowsFeatureManager.getSpaceWorkflowPropertyKeys();
        HashMap keyMap = new HashMap();
        for (String prefix : prefixes) {
            keyMap.put(prefix, new ArrayList());
        }
        block1: for (String key : this.bandanaManager.getKeys(comalatechContext)) {
            if (!key.contains(TEMPLATE)) continue;
            for (String prefix : prefixes) {
                if (!key.startsWith(prefix + TEMPLATE) || this.bandanaManager.getValue(comalatechContext, key) == null) continue;
                ((List)keyMap.get(prefix)).add(key);
                continue block1;
            }
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String prefix : prefixes) {
            names.addAll(this.getKeysNames((List)keyMap.get(prefix), spaceKey, prefix + TEMPLATE));
        }
        return names;
    }

    private List<String> getKeysNames(List<String> keys, String spaceKey, String prefix) {
        String migratedKey;
        Object keysMigrated;
        BandanaContext comalatechContext = this.getBandanaContext(spaceKey);
        if (!(keys.size() != 0 || spaceKey != null || (keysMigrated = this.bandanaManager.getValue(comalatechContext, migratedKey = "migrated_" + prefix)) != null && ((Boolean)keysMigrated).booleanValue())) {
            ConfluenceBandanaContext globalContext = ConfluenceBandanaContext.GLOBAL_CONTEXT;
            for (String key : this.bandanaManager.getKeys((BandanaContext)globalContext)) {
                if (!key.startsWith(prefix) || this.bandanaManager.getValue(comalatechContext, key) == null) continue;
                keys.add(key);
            }
            for (String key : keys) {
                this.bandanaManager.setValue(comalatechContext, key, this.bandanaManager.getValue((BandanaContext)globalContext, key));
            }
            this.bandanaManager.setValue(comalatechContext, migratedKey, (Object)Boolean.TRUE);
        }
        ArrayList<String> names = new ArrayList<String>(keys.size());
        for (String key : keys) {
            names.add(key.substring(prefix.length()));
        }
        return names;
    }

    @Override
    public String getWorkflowTemplateBody(String spaceKey, String name) {
        String workflowContextTemplate = (String)this.bandanaManager.getValue(this.getBandanaContext(spaceKey), this.makeTemplateKey(name), false);
        if (workflowContextTemplate == null) {
            return (String)this.bandanaManager.getValue(this.getBandanaContext(spaceKey), this.makeKey(CDC_TEMPLATE_KEY_PREFIX, name), false);
        }
        return workflowContextTemplate;
    }

    @Override
    public void setWorkflowTemplateBody(String spaceKey, String name, String body) {
        if (log.isDebugEnabled()) {
            log.debug("Saving workflow template, spacekey: " + spaceKey + " body: " + body);
        }
        this.bandanaManager.setValue(this.getBandanaContext(spaceKey), this.makeTemplateKey(name), (Object)body);
        this.incrementProductionsVersion(spaceKey);
    }

    @Override
    public void removeWorkflowTemplate(String spaceKey, String name) {
        this.bandanaManager.removeValue(this.getBandanaContext(spaceKey), this.makeTemplateKey(name));
        if (spaceKey == null) {
            this.bandanaManager.removeValue(this.getBandanaContext(null), this.makeKey(GLOBAL_WORKFLOW_SAMPLE_FLAG_PREFIX, name));
        }
    }

    @Override
    public String createUniqueWorkflowTemplateName(String spaceKey, String name) {
        return this.createUniqueName(CDM_TEMPLATE_KEY_PREFIX, spaceKey, name);
    }

    @Override
    public List<String> getWorkflowTemplatesNames(String spaceKey) {
        String mapCustomSpaceKey;
        if (this.workflowTemplates == null) {
            this.workflowTemplates = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(this.workflowAdvancedConfigurationManager.getCacheGlobalWorkflowNames()).build();
        }
        ArrayList<String> retrievedTemplateNames = new ArrayList<String>();
        String string = mapCustomSpaceKey = spaceKey != null ? spaceKey : "com.comalatech.global.space.key";
        if (log.isDebugEnabled()) {
            log.debug("Workflow template names request for space: " + mapCustomSpaceKey);
        }
        int persistedCacheKey = this.getProductionWorkflowsVersion(spaceKey);
        if (!this.workflowTemplates.containsKey(mapCustomSpaceKey) || this.workflowTemplates.get(mapCustomSpaceKey).getLocalCacheKey() != persistedCacheKey) {
            if (log.isDebugEnabled()) {
                if (this.workflowTemplates.containsKey(mapCustomSpaceKey)) {
                    log.debug("Cached value outdated, getting workflow template names from Bandana");
                } else {
                    log.debug("Value doesn't exist on cache, getting workflow template names from Bandana");
                }
            }
            ArrayList<String> retrievedWorkflowKeys = new ArrayList();
            if (this.workflowsFeatureManager.isWorkflowsLiteApp()) {
                retrievedWorkflowKeys = this.getKeys(spaceKey, CDC_TEMPLATE_KEY_PREFIX);
            } else if (this.workflowsFeatureManager.isWorkflowsApp()) {
                retrievedWorkflowKeys = this.getKeys(spaceKey, CDM_TEMPLATE_KEY_PREFIX);
                if (this.needToRemoveCDCKeys) {
                    retrievedWorkflowKeys.removeAll(this.getKeys(spaceKey, CDC_TEMPLATE_KEY_PREFIX));
                    this.needToRemoveCDCKeys = false;
                }
            }
            this.workflowTemplates.put(mapCustomSpaceKey, new TemplateNamesCache(persistedCacheKey, retrievedWorkflowKeys));
            retrievedTemplateNames.addAll(retrievedWorkflowKeys);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Workflow template names will be retrieved from cache.");
            }
            retrievedTemplateNames.addAll(new HashSet<String>(this.workflowTemplates.get(mapCustomSpaceKey).getWorkflowTemplateNames()));
            if (this.workflowsFeatureManager.isWorkflowsApp() && this.needToRemoveCDCKeys) {
                retrievedTemplateNames.removeAll(this.getKeys(spaceKey, CDC_TEMPLATE_KEY_PREFIX));
                this.needToRemoveCDCKeys = false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Template names for space '" + mapCustomSpaceKey + "': " + retrievedTemplateNames);
        }
        return retrievedTemplateNames;
    }

    @Override
    public String getProductionWorkflowBody(String spaceKey, String name) {
        String workflowBody = null;
        List<String> properties = this.workflowsFeatureManager.getSpaceWorkflowPropertyKeys();
        for (String property : properties) {
            String key = this.makeKey(property + TEMPLATE, name);
            workflowBody = (String)this.bandanaManager.getValue(this.getBandanaContext(spaceKey), key, false);
            if (!StringUtils.isNotBlank((CharSequence)workflowBody)) continue;
            break;
        }
        return workflowBody;
    }

    @Override
    public void setProductionWorkflowBody(String spaceKey, String name, String body) {
        if (log.isDebugEnabled()) {
            log.debug("Saving workflow, spacekey: " + spaceKey + " body: " + body);
        }
        BandanaContext context = this.getBandanaContext(spaceKey);
        List<String> properties = this.workflowsFeatureManager.getSpaceWorkflowPropertyKeys();
        for (int i = 0; i < properties.size(); ++i) {
            if (i == 0) {
                this.bandanaManager.setValue(context, this.makeKey(properties.get(i) + TEMPLATE, name), (Object)body);
                continue;
            }
            this.bandanaManager.removeValue(context, this.makeKey(properties.get(i) + ACTIVE, name));
            this.bandanaManager.removeValue(context, this.makeKey(properties.get(i) + TEMPLATE, name));
        }
    }

    @Override
    public boolean isProductionWorkflowActive(String spaceKey, String name) {
        List<String> properties = this.workflowsFeatureManager.getSpaceWorkflowPropertyKeys();
        for (String property : properties) {
            String key = this.makeKey(property + ACTIVE, name);
            String isActive = (String)this.bandanaManager.getValue(this.getBandanaContext(spaceKey), key);
            if (!StringUtils.isNotBlank((CharSequence)isActive)) continue;
            return Boolean.parseBoolean(isActive);
        }
        return false;
    }

    @Override
    public void setProductionWorkflowActive(String spaceKey, String name, boolean active) {
        String key = this.makeKey(this.workflowsFeatureManager.getSpaceWorkflowPropertyKey() + ACTIVE, name);
        this.bandanaManager.setValue(this.getBandanaContext(spaceKey), key, (Object)Boolean.toString(active));
        this.incrementProductionsVersion(spaceKey);
    }

    @Override
    public void removeProductionWorkflow(String spaceKey, String workflowName) {
        BandanaContext context = this.getBandanaContext(spaceKey);
        List<String> properties = this.workflowsFeatureManager.getSpaceWorkflowPropertyKeys();
        for (String property : properties) {
            String key = this.makeKey(property + ACTIVE, workflowName);
            String isActive = (String)this.bandanaManager.getValue(this.getBandanaContext(spaceKey), key);
            if (!StringUtils.isNotBlank((CharSequence)isActive)) continue;
            this.bandanaManager.removeValue(context, key);
            this.bandanaManager.removeValue(context, this.makeKey(property + TEMPLATE, workflowName));
            break;
        }
    }

    @Override
    public int getProductionWorkflowsCount() {
        BandanaContext context = this.getBandanaContext(null);
        List<String> properties = this.workflowsFeatureManager.getSpaceWorkflowPropertyKeys();
        int count = 0;
        block0: for (String key : this.bandanaManager.getKeys(context)) {
            for (String property : properties) {
                if (!key.startsWith(property + ACTIVE)) continue;
                Object value = this.bandanaManager.getValue(context, key);
                if (value == null || !value.toString().startsWith(Boolean.TRUE.toString())) continue block0;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    @Override
    public String createUniqueProductionWorkflowName(String spaceKey, String name) {
        return this.createUniqueName(this.workflowsFeatureManager.getSpaceWorkflowPropertyKey() + TEMPLATE, spaceKey, name);
    }

    @Override
    public List<String> getProductionWorkflowsKeys(String spaceKey) {
        return this.getKeys(spaceKey);
    }

    @Override
    public int getProductionWorkflowsVersion(String spaceKey) {
        String value = (String)this.bandanaManager.getValue(this.getBandanaContext(spaceKey), PRODUCTION_WORKFLOW_VERSION_KEY);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private void incrementProductionsVersion(String spaceKey) {
        int version = 0;
        BandanaContext bandanaContext = this.getBandanaContext(spaceKey);
        String value = (String)this.bandanaManager.getValue(bandanaContext, PRODUCTION_WORKFLOW_VERSION_KEY);
        if (value != null) {
            try {
                version = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ++version;
        if (log.isDebugEnabled()) {
            log.debug("increment workflow cache key for space: " + spaceKey + " value: " + version);
        }
        this.bandanaManager.setValue(bandanaContext, PRODUCTION_WORKFLOW_VERSION_KEY, (Object)Integer.toString(version));
    }

    @Override
    public void setGlobalSampleWorkflow(String name, boolean sample) {
        this.bandanaManager.setValue(this.getBandanaContext(null), this.makeKey(GLOBAL_WORKFLOW_SAMPLE_FLAG_PREFIX, name), (Object)Boolean.toString(sample));
    }

    @Override
    public boolean isGlobalSampleWorkflow(String name) {
        return Boolean.TRUE.toString().equals(this.bandanaManager.getValue(this.getBandanaContext(null), GLOBAL_WORKFLOW_SAMPLE_FLAG_PREFIX + name));
    }

    private String makeTemplateKey(String name) {
        if (this.workflowsFeatureManager.isWorkflowsLiteApp()) {
            return this.makeKey(CDC_TEMPLATE_KEY_PREFIX, name);
        }
        return this.makeKey(CDM_TEMPLATE_KEY_PREFIX, name);
    }

    private String makeWorkflowActiveFlagKey(String workflowName) {
        return this.makeKey(GLOBAL_WORKFLOW_ACTIVE_FLAG_PREFIX, workflowName);
    }

    private String makeKey(String prefix, String name) {
        String key = prefix + name.trim();
        if (key.length() > 100 || prefix.contains(ACTIVE) && key.length() > 98) {
            key = prefix + name.hashCode();
        }
        return key;
    }

    @Override
    public boolean isGlobalWorkflowTemplateActive(String spaceKey, String globalWorkflowName) {
        String key = this.makeWorkflowActiveFlagKey(globalWorkflowName);
        String flag = (String)this.bandanaManager.getValue(this.getBandanaContext(spaceKey), key, true);
        return flag == null || Boolean.TRUE.toString().equals(flag);
    }

    @Override
    public void setGlobalWorkflowTemplateActive(String spaceKey, String globalWorkflowName, boolean active) {
        String key = this.makeWorkflowActiveFlagKey(globalWorkflowName);
        this.bandanaManager.setValue(this.getBandanaContext(spaceKey), key, (Object)Boolean.toString(active));
    }

    private boolean workflowExists(String prefix, String spaceKey, String name) {
        String key = this.makeKey(prefix, name);
        return this.bandanaManager.getValue(this.getBandanaContext(spaceKey), key) != null;
    }

    private String createUniqueName(String prefix, String spaceKey, String name) {
        String newName;
        if (!this.workflowExists(prefix, spaceKey, name)) {
            return name;
        }
        String copySuffix = this.comalaI18nBean.getText("comalatech.awp.copy.label");
        int count = 1;
        int ix = name.lastIndexOf(copySuffix);
        if (ix > 0) {
            if (ix + copySuffix.length() > name.length()) {
                newName = name;
            } else {
                try {
                    String lastCount = name.substring(ix + copySuffix.length()).trim();
                    count = Integer.parseInt(lastCount) + 1;
                    newName = name.substring(0, ix + copySuffix.length());
                }
                catch (NumberFormatException e) {
                    newName = name + " " + copySuffix;
                }
            }
        } else {
            newName = name + " " + copySuffix;
        }
        while (this.workflowExists(prefix, spaceKey, newName + " " + count)) {
            ++count;
        }
        return newName + " " + count;
    }

    @Override
    public void setWorkflowTemplateBackup(String spaceKey, String workflowName, String workflowMarkup) {
        this.bandanaManager.setValue(this.getBandanaContext(spaceKey), this.makeKey(StringUtils.isEmpty((CharSequence)spaceKey) ? "com.comalatech.worflow.global.backup." : "com.comalatech.worflow.backup.", workflowName), (Object)workflowMarkup);
    }

    @Override
    public String getWorkflowTemplateBackup(String spaceKey, String workflowName) {
        return (String)this.bandanaManager.getValue(this.getBandanaContext(spaceKey), this.makeKey(StringUtils.isEmpty((CharSequence)spaceKey) ? "com.comalatech.worflow.global.backup." : "com.comalatech.worflow.backup.", workflowName), false);
    }

    @Override
    public void removeWorkflowTemplateBackup(String spaceKey, String workflowName) {
        this.bandanaManager.removeValue(this.getBandanaContext(spaceKey), this.makeKey(StringUtils.isEmpty((CharSequence)spaceKey) ? "com.comalatech.worflow.global.backup." : "com.comalatech.worflow.backup.", workflowName));
    }

    public static class TemplateNamesCache {
        private final int localCacheKey;
        private final List<String> workflowTemplateNames;

        public TemplateNamesCache(int localCacheKey, List<String> workflowTemplateNames) {
            this.localCacheKey = localCacheKey;
            this.workflowTemplateNames = workflowTemplateNames;
        }

        public int getLocalCacheKey() {
            return this.localCacheKey;
        }

        public List<String> getWorkflowTemplateNames() {
            return this.workflowTemplateNames;
        }
    }
}

