/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function (CW, $) {
    CW.toInit(function() {
        // Remove inline comment button
        CW.observeDOM(document.body, function() {
            var $actionPanel = $('#inline-dialog-selection-action-panel');
            var $actionTarget = $('#action-dialog-target');
            if ($actionPanel.length > 0) {
                var $inlineCommentButton = $actionPanel.find('[data-key$=create-inline-comment]');
                if ($inlineCommentButton.length > 0) {
                    var $buttons = $actionPanel.find('.aui-inline-dialog-contents button');
                    if ($buttons.length <= 1) {
                        // if the inline dialog only contains the inline comment button
                        // remove the inline dialog and the trigger
                        $actionPanel.remove();
                        $actionTarget.remove();
                    } else {
                        // if it contains more buttons, just remove inline comment option
                        $inlineCommentButton.remove();
                    }
                }
            } else if ($actionTarget.length > 0) {
                // remove the inline dialog trigger
                $actionTarget.remove();
            }
        });
    });
});