/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var AWP = AWP || {};
(function ($) {

    var showGettingStartedDialog = function () {

        var theDialog = new AJS.Dialog({
                    "width": 860,
                    "height": 550,
                    "id": "workflow-getting-started-dialog",
                    closeOnOutsideClick: true
                });
        theDialog.addHeader(AJS.I18n.getText("workflow.upm.gettingstarted.header"));
        theDialog.addPanel("",AWP.Templates.gettingstarted(),"workflow-gettingstarted-panel");
        theDialog.addLink(AJS.I18n.getText("close.name"), function (dialog) {
            dialog.hide();
        }, "#");

        theDialog.gotoPage(0);
        theDialog.show();
    }

    if (upm) {
        // For the "Get Started" button
        $("div.upm-details").live(
            "detailsLoaded",
            function(ev) {
                if (upm.createHash) { //Some older versions of the UPM don't have this. The Get started buttons don't seem to exist in these UPM versions anyway.
                    $("#upm-plugin-" + upm.createHash("com.comalatech.workflow", "manage") + " .upm-get-started").unbind("click").click(function(ev) {
                        showGettingStartedDialog();
                        return false;
                    });
                }
            }
        );

        var isWorkflowsRelated = function (pluginStatusDialog){
            return pluginStatusDialog.id === "upm-plugin-status-dialog" &&
                $(".plugin-name-version .plugin-name", pluginStatusDialog.getPage(0).body).text() === "Comala Workflows";
        };

        var defaultUpmStatusDialog = upm.showPluginStatusDialog;
        upm.showPluginStatusDialog = function(heading, pluginElement, body, button, buttonHandler, htmlBody) {
            defaultUpmStatusDialog(
                heading,
                pluginElement,
                body,
                button,
                (function() {
                    return function(upmStatusDialog) {
                        if (isWorkflowsRelated(upmStatusDialog)) {
                            upmStatusDialog.remove();
                            showGettingStartedDialog();
                            return false;
                        } else if (buttonHandler) {
                            buttonHandler(upmStatusDialog);
                        }
                    }
                })(),
                htmlBody
            );
        };

    }

})(AJS.$);
