/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.param.format;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.randombits.confluence.filtering.param.BaseParameter;
import org.randombits.confluence.filtering.param.ParameterException;
import org.randombits.confluence.support.MacroInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberFormatParameter
extends BaseParameter<NumberFormat> {
    private static final String FORMAT_PARAM = "format";
    private static final String STANDARD_FORMAT = "standard";
    private static final String NUMBER_FORMAT = "number";
    private static final String INTEGER_FORMAT = "integer";
    private static final String PERCENT_FORMAT = "percent";
    private static final String CURRENCY_FORMAT = "currency";

    public NumberFormatParameter() {
        this(null);
    }

    public NumberFormatParameter(String defaultValue) {
        super(defaultValue, FORMAT_PARAM);
    }

    public NumberFormat findNumberFormat(MacroInfo info) throws ParameterException {
        return (NumberFormat)this.findValue(info);
    }

    @Override
    protected NumberFormat findObject(String paramValue, MacroInfo info) throws ParameterException {
        return this.getNumberFormat(paramValue);
    }

    private NumberFormat getNumberFormat(String format) {
        if (STANDARD_FORMAT.equals(format)) {
            return NumberFormat.getInstance();
        }
        if (CURRENCY_FORMAT.equals(format)) {
            return NumberFormat.getCurrencyInstance();
        }
        if (INTEGER_FORMAT.equals(format)) {
            return NumberFormat.getIntegerInstance();
        }
        if (PERCENT_FORMAT.equals(format)) {
            return NumberFormat.getPercentInstance();
        }
        if (NUMBER_FORMAT.equals(format)) {
            return NumberFormat.getNumberInstance();
        }
        if (format != null) {
            return new DecimalFormat(format);
        }
        return null;
    }
}

