/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.param.criteria;

import com.atlassian.confluence.core.ListQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.randombits.confluence.filtering.criteria.Criteria;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.GroupCriteria;
import org.randombits.confluence.filtering.criteria.SourceCriterion;
import org.randombits.confluence.filtering.param.ListQueryParameter;
import org.randombits.confluence.filtering.param.ParameterException;
import org.randombits.confluence.filtering.param.criteria.CriterionParameter;
import org.randombits.confluence.filtering.param.criteria.content.ContentScopeParameter;
import org.randombits.confluence.filtering.param.criteria.content.ContentTypeParameter;
import org.randombits.confluence.filtering.param.criteria.content.LabelParameter;
import org.randombits.confluence.filtering.param.criteria.content.SpaceKeyParameter;
import org.randombits.confluence.support.MacroInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriterionParameterGroup {
    private List<CriterionParameter> params = new ArrayList<CriterionParameter>();

    public void addParameter(CriterionParameter parameter) {
        this.params.add(parameter);
    }

    public Criteria createCriteria(MacroInfo info) throws ParameterException {
        return this.createCriteria(info, true);
    }

    public Criteria createCriteria(MacroInfo info, boolean matchAll) throws ParameterException {
        GroupCriteria criteria = new GroupCriteria(matchAll, new Criterion[0]);
        return this.addCriteria(criteria, info);
    }

    public Criteria addCriteria(Criteria criteria, MacroInfo info) throws ParameterException {
        for (CriterionParameter parameter : this.params) {
            Criterion criterion = parameter.createCriterion(info);
            if (criterion == null) continue;
            criteria.addCriterion(criterion);
        }
        return criteria;
    }

    public Collection<?> getMatchingValues(MacroInfo info, boolean matchAll) throws ParameterException {
        Criteria criteria = this.createCriteria(info, matchAll);
        if (criteria instanceof SourceCriterion) {
            SourceCriterion source = (SourceCriterion)((Object)criteria);
            return source.getMatchingValues();
        }
        return null;
    }

    public void prepareListQuery(ListQuery query, MacroInfo info) throws ParameterException {
        for (CriterionParameter parameter : this.params) {
            if (!(parameter instanceof ListQueryParameter)) continue;
            ((ListQueryParameter)((Object)parameter)).prepareListQuery(query, info);
        }
    }

    public static CriterionParameterGroup standardPageFilters() {
        CriterionParameterGroup params = new CriterionParameterGroup();
        params.addParameter(new ContentTypeParameter());
        params.addParameter(new LabelParameter());
        params.addParameter(new ContentScopeParameter());
        params.addParameter(new SpaceKeyParameter());
        return params;
    }
}

