/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.resources;

import com.comalatech.confluence.workflowreports.service.DocumentReportService;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/document/report")
@Produces(value={"application/json"})
public class DocumentReportResource {
    private static final Logger log = LoggerFactory.getLogger(DocumentReportResource.class);
    private final DocumentReportService approvalDocumentReportService;
    private final DocumentReportService actionsReportService;
    private final DocumentReportService taskDocumentReportService;

    public DocumentReportResource(@Qualifier(value="approvalsReportService") DocumentReportService approvalDocumentReportService, @Qualifier(value="actionsReportService") DocumentReportService actionsReportService, @Qualifier(value="tasksReportService") DocumentReportService taskDocumentReportService) {
        this.approvalDocumentReportService = approvalDocumentReportService;
        this.actionsReportService = actionsReportService;
        this.taskDocumentReportService = taskDocumentReportService;
    }

    @Path(value="/approvals")
    @Produces(value={"application/json"})
    @GET
    public Response getApprovals(@QueryParam(value="cql") String cql, @QueryParam(value="start") int start, @QueryParam(value="limit") int limit) {
        try {
            return Response.ok((Object)this.approvalDocumentReportService.generateDocumentReport(cql, start, limit)).build();
        }
        catch (Exception e) {
            log.error("Unable to retrieve data for approval report CQL: {} , start: {} ,limit: {} ", new Object[]{cql, start, limit, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/actions")
    @Produces(value={"application/json"})
    @GET
    public Response getActions(@QueryParam(value="cql") String cql, @QueryParam(value="start") int start, @QueryParam(value="limit") int limit) {
        try {
            return Response.ok((Object)this.actionsReportService.generateDocumentReport(cql, start, limit)).build();
        }
        catch (Exception e) {
            log.error("Unable to retrieve data for actions report CQL: {} , start: {} ,limit: {} ", new Object[]{cql, start, limit, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/tasks")
    @Produces(value={"application/json"})
    @GET
    public Response getTasks(@QueryParam(value="cql") String cql, @QueryParam(value="start") int start, @QueryParam(value="limit") int limit) {
        try {
            return Response.ok((Object)this.taskDocumentReportService.generateDocumentReport(cql, start, limit)).build();
        }
        catch (Exception e) {
            log.error("Unable to retrieve data for tasks report CQL: {} , start: {} ,limit: {} ", new Object[]{cql, start, limit, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }
}

