/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model.stats;

import com.comalatech.confluence.workflowreports.macro.parameter.FieldListReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.ReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.StringListReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.stats.StatsReportParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DocumentStatsReportOptions {
    private final List<String> spaceKeys;
    private String spaceKey;
    private final List<String> labels;
    private final String parentPageId;
    private List<String> stateNames;
    private String stateName;
    private final List<String> workflows;
    private final boolean allLabelsMandatory;

    public DocumentStatsReportOptions(List<ReportParameter> parameters) {
        HashMap paramValues = new HashMap();
        for (ReportParameter p : parameters) {
            paramValues.put(p.getKey(), p.getValue());
        }
        this.parentPageId = this.getStringValueFrom((ReportParameterValue)paramValues.get(StatsReportParameters.PARENT_PAGE.getKey()));
        this.stateNames = this.getListValueFrom((ReportParameterValue)paramValues.get(StatsReportParameters.STATE.getKey()));
        this.workflows = this.getListValueFrom((ReportParameterValue)paramValues.get(StatsReportParameters.WORKFLOW.getKey()));
        this.spaceKeys = this.getListValueFrom((ReportParameterValue)paramValues.get(StatsReportParameters.SPACE.getKey()));
        if (this.spaceKeys.size() == 1) {
            this.spaceKey = this.spaceKeys.get(0);
        }
        boolean mandatoryLabels = false;
        this.labels = new ArrayList<String>();
        for (String label : this.getListValueFrom((ReportParameterValue)paramValues.get(StatsReportParameters.LABEL.getKey()))) {
            if (label.startsWith("&")) {
                mandatoryLabels = true;
            }
            this.labels.add(StringUtils.removeStart((String)label, (String)"&"));
        }
        this.allLabelsMandatory = mandatoryLabels;
    }

    private String getStringValueFrom(ReportParameterValue value) {
        if (value instanceof StringReportParameterValue) {
            return (String)((StringReportParameterValue)value).getValue();
        }
        return null;
    }

    private List getListValueFrom(ReportParameterValue value) {
        if (value instanceof StringListReportParameterValue) {
            return (List)((StringListReportParameterValue)value).getValue();
        }
        if (value instanceof FieldListReportParameterValue) {
            return (List)((FieldListReportParameterValue)value).getValue();
        }
        return Collections.emptyList();
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getParentPageId() {
        return this.parentPageId;
    }

    public boolean isAllLabelsMandatory() {
        return this.allLabelsMandatory;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public List<String> getStateNames() {
        return this.stateNames;
    }

    public List<String> getSpaceKeys() {
        return this.spaceKeys;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public List<String> getWorkflows() {
        return this.workflows;
    }

    public void setStateNames(List<String> stateNames) {
        this.stateNames = stateNames;
    }
}

