/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model.presenter;

import com.comalatech.confluence.workflowreports.model.WorkflowStatesReportOptions;
import com.comalatech.confluence.workflowreports.model.presenter.AbstractReportOptionsCqlUtility;
import com.comalatech.confluence.workflowreports.model.presenter.MacroParametersPresenter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowStateReportOptionsCqlPresenter
extends AbstractReportOptionsCqlUtility
implements MacroParametersPresenter {
    private static final Logger log = LoggerFactory.getLogger(WorkflowStateReportOptionsCqlPresenter.class);
    protected static final String ITEMS_PER_PAGE_KEY = "numberOfItems";
    protected static final String COLUMNS_TO_SHOW_KEY = "columnsToShow";
    protected static final String SORT_KEY = "sort";
    protected static final String SORT_ORDER_KEY = "sortOrder";
    private final WorkflowStatesReportOptions options;

    public WorkflowStateReportOptionsCqlPresenter(WorkflowStatesReportOptions options, ObjectMapper objectMapper) {
        super(options, objectMapper);
        this.options = options;
    }

    @Override
    public Map<String, Object> present() {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        propertiesMap.put(ITEMS_PER_PAGE_KEY, this.options.getNumberOfItemsPerPage());
        propertiesMap.put(COLUMNS_TO_SHOW_KEY, this.options.getColumnsToShow());
        propertiesMap.put(SORT_KEY, this.options.getSort());
        propertiesMap.put(SORT_ORDER_KEY, this.options.getSortOrder());
        propertiesMap.putAll(this.propertiesForLiveFiltering());
        Map<String, String> cql = this.propertiesForCql();
        if (!this.options.isSingleSpace()) {
            String cqlString = this.buildWorkflowCqlParams(cql.get("cqlQuery"));
            cql = Collections.singletonMap("cqlQuery", cqlString);
        }
        propertiesMap.putAll(cql);
        return propertiesMap;
    }
}

