/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.manager.approvals;

import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.restv2.model.documentreport.DocumentReport;
import com.comalatech.confluence.workflow.restv2.model.documentreport.WorkflowsReportData;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import com.comalatech.confluence.workflowreports.manager.approvals.WorkflowApprovalsReportManager;
import com.comalatech.confluence.workflowreports.model.ExportWorkflowApprovalReportEntry;
import com.comalatech.confluence.workflowreports.model.WorkflowApprovalsReportOptions;
import com.comalatech.confluence.workflowreports.service.ApprovalsReportService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExportApprovalsReport
implements WorkflowApprovalsReportManager {
    private static final Logger log = LoggerFactory.getLogger(ExportApprovalsReport.class);
    private static final int LIMIT = 20;
    private static final String REPORT_CQL_FILTER = "awphasworkflow=true";
    private static final String CQL_QUERY_PARAM = "cqlQuery";
    public final CQLSearchService cqlSearchService;
    public final PageManager pageManager;
    public final StateAccessor stateAccessor;
    public final WorkflowUserAccessor workflowUserAccessor;
    private final ApprovalsReportService approvalsReportService;

    public ExportApprovalsReport(CQLSearchService cqlSearchService, PageManager pageManager, StateAccessor stateAccessor, WorkflowUserAccessor workflowUserAccessor, ApprovalsReportService approvalsReportService) {
        this.cqlSearchService = cqlSearchService;
        this.pageManager = pageManager;
        this.stateAccessor = stateAccessor;
        this.workflowUserAccessor = workflowUserAccessor;
        this.approvalsReportService = approvalsReportService;
    }

    @Override
    public List<ExportWorkflowApprovalReportEntry> createReport(WorkflowApprovalsReportOptions options, Map<String, Object> parameters) {
        int start = 0;
        int limit = StringUtils.isNotBlank((CharSequence)options.getNumberOfItemsPerPage()) ? Integer.parseInt(options.getNumberOfItemsPerPage()) : 20;
        DocumentReport report = this.approvalsReportService.generateDocumentReport(this.buildCqlQuery(options, parameters), start, limit);
        try {
            return this.buildReport(report);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    private String buildCqlQuery(WorkflowApprovalsReportOptions options, Map<String, Object> parameters) {
        StringJoiner stateJoiner = new StringJoiner("\",\"", "state IN (\"", "\")");
        options.getStates().forEach(stateJoiner::add);
        StringJoiner workflowJoiner = new StringJoiner("\",\"", "workflowname IN (\"", "\")");
        options.getWorkflows().forEach(workflowJoiner::add);
        String cqlQuery = REPORT_CQL_FILTER;
        cqlQuery = StringUtils.isNotBlank((CharSequence)((String)parameters.get(CQL_QUERY_PARAM))) ? cqlQuery + " AND " + parameters.get(CQL_QUERY_PARAM) : cqlQuery;
        cqlQuery = !options.getStates().isEmpty() ? cqlQuery + " AND " + stateJoiner : cqlQuery;
        cqlQuery = !options.getWorkflows().isEmpty() ? cqlQuery + " AND " + workflowJoiner : cqlQuery;
        return cqlQuery;
    }

    private List<ExportWorkflowApprovalReportEntry> buildReport(DocumentReport results) throws WorkflowException {
        ArrayList<ExportWorkflowApprovalReportEntry> report = new ArrayList<ExportWorkflowApprovalReportEntry>();
        for (WorkflowsReportData result : results.getWorkflowsReportList()) {
            report.addAll(this.buildEntry(result));
        }
        return report;
    }

    private List<ExportWorkflowApprovalReportEntry> buildEntry(WorkflowsReportData result) throws WorkflowException {
        AbstractPage page = this.pageManager.getAbstractPage(result.getContentData().getId());
        if (page == null) {
            throw new WorkflowException("There was an error while creating the report.");
        }
        PageState latestFinalState = this.stateAccessor.getLatestFinalState(page);
        if (result.getApprovals() != null && !result.getApprovals().isEmpty()) {
            return result.getApprovals().stream().map(approvalContent -> {
                List<ExportWorkflowApprovalReportEntry.CompletedApprover> approvers = approvalContent.completed.stream().map(r -> new ExportWorkflowApprovalReportEntry.CompletedApprover(r.user.displayName, r.action.equals("approved") ? "Approved" : "Rejected", TimerUtils.parseDateWithConfluenceDateFormat(new Date(Long.parseLong(r.date))))).collect(Collectors.toList());
                String pendingApprovers = approvalContent.pendingApprovers.stream().map(r -> r.displayName).collect(Collectors.joining(","));
                return ExportWorkflowApprovalReportEntry.builder().title(page.getTitle()).pageLink(this.getBaseUrl() + page.getUrlPath()).approvedVersion(latestFinalState != null ? "v" + latestFinalState.getContentVersion() : null).approvedVersionLink(page.getIdAsString() != null ? this.getBaseUrl() + "/pages/releaseview.action?pageId=" + page.getIdAsString() : null).approval(approvalContent.name).pendingApprovers(pendingApprovers).approvedVersionApprovers(approvers).state(result.getCurrentState()).updated(TimerUtils.parseDateWithConfluenceDateFormat(page.getLastModificationDate())).updatedBy(page.getLastModifier().getFullName()).status(approvalContent.status).build();
            }).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    private String getBaseUrl() {
        String domainName = GeneralUtil.getGlobalSettings().getBaseUrl();
        if (StringUtils.isNotBlank((CharSequence)domainName) && domainName.endsWith("/")) {
            domainName = domainName.substring(0, domainName.length() - 1);
        }
        return domainName;
    }
}

