/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.model;

import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public enum ActionsReportParameters {
    SPACE("space", "@self"),
    ITEMS_PER_PAGE("maxItems", "20"),
    ASSIGNEE("assignee", "@self"),
    PARENT_PAGE("parent"),
    LABEL("label"),
    STATE("state"),
    WORKFLOW("workflow"),
    CQL_FILTER("cqlFilter");

    final String key;
    String defaultValue;

    private ActionsReportParameters(String key) {
        this.key = key;
    }

    private ActionsReportParameters(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public static List<ReportParameter> getFiltersFrom(Set<Map.Entry> macroParameterSet) {
        ArrayList<ReportParameter> actionsReportFilters = new ArrayList<ReportParameter>();
        for (Map.Entry macroParam : macroParameterSet) {
            Optional<ActionsReportParameters> filter = ActionsReportParameters.fromString(macroParam.getKey().toString());
            if (!filter.isPresent()) continue;
            String value = macroParam.getValue() == null ? null : macroParam.getValue().toString().trim();
            actionsReportFilters.add(new ReportParameter(filter.get().key, new StringReportParameterValue(value, filter.get().defaultValue)));
        }
        ActionsReportParameters.addMandatoryParameters(actionsReportFilters);
        return actionsReportFilters;
    }

    private static Optional<ActionsReportParameters> fromString(String text) {
        return Arrays.stream(ActionsReportParameters.values()).filter(reportFilter -> reportFilter.key.equalsIgnoreCase(text)).findFirst();
    }

    private static void addMandatoryParameters(List<ReportParameter> actionsReportFilters) {
        boolean existAssignee;
        boolean existItemsPerPage;
        boolean existSpaceParam = actionsReportFilters.stream().anyMatch(param -> param.getKey().equals(SPACE.getKey()));
        if (!existSpaceParam) {
            actionsReportFilters.add(new ReportParameter(ActionsReportParameters.SPACE.key, new StringReportParameterValue(null, ActionsReportParameters.SPACE.defaultValue)));
        }
        if (!(existItemsPerPage = actionsReportFilters.stream().anyMatch(param -> param.getKey().equals(ITEMS_PER_PAGE.getKey())))) {
            actionsReportFilters.add(new ReportParameter(ActionsReportParameters.ITEMS_PER_PAGE.key, new StringReportParameterValue(null, ActionsReportParameters.ITEMS_PER_PAGE.defaultValue)));
        }
        if (!(existAssignee = actionsReportFilters.stream().anyMatch(param -> param.getKey().equals(ASSIGNEE.getKey())))) {
            actionsReportFilters.add(new ReportParameter(ActionsReportParameters.ASSIGNEE.key, new StringReportParameterValue(null, ActionsReportParameters.ASSIGNEE.defaultValue)));
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

