/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.mappers;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ApprovalsReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.model.StateReportParameters;
import org.apache.commons.lang3.StringUtils;

public class ParentPageParameterMapper
implements ParameterMapper {
    private final PageManager pageManager;
    private final AbstractPage currentPage;

    public ParentPageParameterMapper(PageManager pageManager, AbstractPage page) {
        this.pageManager = pageManager;
        this.currentPage = page;
    }

    @Override
    public ReportParameter map(ReportParameter parameter) {
        StringReportParameterValue value;
        String parentTitle;
        if (this.parameterCanBeMapped(parameter) && StringUtils.isNotBlank((CharSequence)(parentTitle = (value = (StringReportParameterValue)parameter.getValue()).getValueOrDefault()))) {
            String pageSpaceKey = this.currentPage != null ? this.currentPage.getSpaceKey() : "";
            String pageTitle = parentTitle;
            String[] pageInSpaceFormatTokens = pageTitle.split(":");
            if (pageInSpaceFormatTokens.length > 1) {
                pageSpaceKey = pageInSpaceFormatTokens[0];
                pageTitle = pageInSpaceFormatTokens[1];
            }
            String pageId = "";
            if ("@self".equals(pageTitle)) {
                pageId = this.currentPage != null ? this.currentPage.getIdAsString() : null;
            } else {
                Page page = this.pageManager.getPage(pageSpaceKey, pageTitle);
                if (page != null) {
                    pageId = page.getIdAsString();
                }
            }
            parameter.setValue(new StringReportParameterValue(pageId, (String)value.getDefaultValue()));
        }
        return parameter;
    }

    @Override
    public boolean parameterCanBeMapped(ReportParameter parameter) {
        return (parameter.keyIs(StateReportParameters.PARENT_PAGE.getKey()) || parameter.keyIs(ApprovalsReportParameters.PARENT_PAGE.getKey())) && parameter.getValue() instanceof StringReportParameterValue;
    }
}

