/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.action;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.workflow.StateService;

@ReadOnlyAccessBlocked
public class StateInitializationAction
extends AbstractSpaceAction
implements SpaceAware {
    @ComponentImport
    protected EventPublisher eventPublisher;
    private StateService stateService;
    private String stateName;
    private boolean override;
    private String workflowName;
    private LongRunningTaskId taskId;

    public String execute() throws Exception {
        this.taskId = this.stateService.setState(this.workflowName, this.stateName, this.override, this.getSpaceKey());
        return "success";
    }

    @ParameterSafe
    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    @ParameterSafe
    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @ParameterSafe
    public void setOverride(boolean override) {
        this.override = override;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }

    private boolean isConfluenceAdministrator() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public boolean isPermitted() {
        return super.isPermitted() && (this.isConfluenceAdministrator() || this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.getSpace()));
    }

    public String getTaskId() {
        return this.taskId.toString();
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }
}

