/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.action;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflowcontainer.action.RepositoryActionHelper;

public class SpaceWorkflowsRepositoryAction
extends AbstractSpaceAction
implements SpaceAware {
    private RepositoryActionHelper repositoryActionHelper;
    private WorkflowConfigurationManager workflowConfigurationManager;
    private AdhocWorkflowsLicenseManager licenseManager;
    private String licenseStatusMessage;
    private String docoUrl = "https://apps.appf.re/cdmdc/doc/spaceimportworkflow/8jyxoF";

    public String execute() throws Exception {
        this.init();
        this.licenseStatusMessage = this.licenseManager.getLicenseStatus().getMessageHtml();
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String install() throws Exception {
        this.init();
        return this.repositoryActionHelper.install();
    }

    private boolean isConfluenceAdministrator() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    @ParameterSafe
    public void setCategory(String category) {
        this.repositoryActionHelper.setCategory(category);
    }

    @ParameterSafe
    public void setReload(boolean reload) {
        this.repositoryActionHelper.setReload(reload);
    }

    @ParameterSafe
    public void setWorkflowId(String workflowId) {
        this.repositoryActionHelper.setWorkflowId(workflowId);
    }

    @ParameterSafe
    public void setSection(String section) {
        this.repositoryActionHelper.setSection(section);
    }

    public String getSection() {
        return this.repositoryActionHelper.getSection();
    }

    public void init() {
        this.repositoryActionHelper.setSpaceKey(this.getSpaceKey());
    }

    public RepositoryActionHelper getRepositoryActionHelper() {
        return this.repositoryActionHelper;
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public boolean isPermitted() {
        return (super.isPermitted() && this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.getSpace()) || this.isConfluenceAdministrator()) && this.workflowConfigurationManager.canImportWorkflows(this.getAuthenticatedUser());
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public void setLicenseManager(AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setRepositoryActionHelper(RepositoryActionHelper repositoryActionHelper) {
        this.repositoryActionHelper = repositoryActionHelper;
    }

    @HtmlSafe
    public String getLicenseStatusMessage() {
        return this.licenseStatusMessage;
    }

    public String getDocoUrl() {
        return this.docoUrl;
    }
}

